/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.energy;

import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class BlockEnergyWrapper
implements IEnergyStorage {
    LazyOptional<IEnergyStorage> tileEnergy;
    LazyOptional<IItemHandler> itemHandler;

    public BlockEnergyWrapper(LazyOptional<IEnergyStorage> tileEnergyIn, LazyOptional<IItemHandler> itemHandlerIn) {
        this.tileEnergy = tileEnergyIn;
        this.itemHandler = itemHandlerIn;
    }

    protected BlockEnergyWrapper() {
        this.tileEnergy = LazyOptional.empty();
        this.itemHandler = LazyOptional.empty();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int batteryRecieved = this.getBatteryEnergyHandler().map(battery -> battery.receiveEnergy(maxReceive, simulate)).orElse(0);
        int tileRecieved = this.tileEnergy.map(tile -> tile.receiveEnergy(maxReceive - batteryRecieved, simulate)).orElse(0);
        return batteryRecieved + tileRecieved;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int tileExtracted = this.tileEnergy.map(tile -> tile.extractEnergy(maxExtract, simulate)).orElse(0);
        int batteryExtracted = this.getBatteryEnergyHandler().map(battery -> battery.extractEnergy(maxExtract - tileExtracted, simulate)).orElse(0);
        return tileExtracted + batteryExtracted;
    }

    public int getEnergyStored() {
        return this.getBatteryEnergyHandler().map(IEnergyStorage::getEnergyStored).orElse(0) + this.tileEnergy.map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public int getMaxEnergyStored() {
        return this.getBatteryEnergyHandler().map(IEnergyStorage::getMaxEnergyStored).orElse(0) + this.tileEnergy.map(IEnergyStorage::getMaxEnergyStored).orElse(0);
    }

    public boolean canExtract() {
        return this.getBatteryEnergyHandler().map(IEnergyStorage::canExtract).orElse(false) != false || this.tileEnergy.map(IEnergyStorage::canExtract).orElse(false) != false;
    }

    public boolean canReceive() {
        return this.getBatteryEnergyHandler().map(IEnergyStorage::canReceive).orElse(false) != false || this.tileEnergy.map(IEnergyStorage::canReceive).orElse(false) != false;
    }

    LazyOptional<IEnergyStorage> getBatteryEnergyHandler() {
        return this.itemHandler.map(iItemHandler -> iItemHandler.getStackInSlot(0).getCapability(ForgeCapabilities.ENERGY)).orElse(LazyOptional.empty());
    }
}

