/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.inventory.modechanging;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.client.render.NuminaRenderer;
import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.capabilities.module.blockbreaking.IBlockBreakingModule;
import lehjr.numina.common.capabilities.module.externalitems.IOtherModItemsAsModules;
import lehjr.numina.common.capabilities.module.miningenhancement.IMiningEnhancementModule;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.rightclick.IRightClickModule;
import lehjr.numina.common.capabilities.module.toggleable.IToggleableModule;
import lehjr.numina.common.energy.ElectricItemUtils;
import lehjr.numina.common.item.ItemUtils;
import lehjr.numina.common.math.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public interface IModeChangingItem
extends IModularItem {
    public static final String TAG_MODE = "mode";

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public BakedModel getInventoryModel();

    @OnlyIn(value=Dist.CLIENT)
    default public void drawModeChangeIcon(LocalPlayer player, int hotbarIndex, ForgeGui gui, Minecraft mc, GuiGraphics gfx, float partialTick, int screenWidth, int screenHeight) {
        ItemStack module = this.getActiveModule();
        if (!module.m_41619_()) {
            int baroffset = 22;
            if (!player.m_7500_()) {
                baroffset += 16;
                int totalArmorValue = player.m_21230_();
                baroffset += 8 * (int)Math.ceil((double)totalArmorValue / 20.0);
            }
            baroffset = screenHeight - baroffset;
            double currX = (double)screenWidth / 2.0 - 89.0 + 20.0 * (double)hotbarIndex;
            double currY = baroffset - 18;
            Color.WHITE.setShaderColor();
            if (module.getCapability(NuminaCapabilities.POWER_MODULE).map(pm -> pm.isModuleOnline()).orElse(false).booleanValue()) {
                gfx.m_280480_(module.getCapability(NuminaCapabilities.CHAMELEON).map(iChameleon -> iChameleon.getStackToRender()).orElse(module), (int)currX, (int)currY);
            } else {
                NuminaRenderer.drawModuleAt(gfx, currX, currY, module.getCapability(NuminaCapabilities.CHAMELEON).map(iChameleon -> iChameleon.getStackToRender()).orElse(module), false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void drawModeChangingModularItemIcon(LocalPlayer player, int hotbarIndex, ForgeGui gui, Minecraft mc, GuiGraphics gfx, float partialTick, int screenWidth, int screenHeight) {
        ItemStack modularItem = this.getModularItemStack();
        if (!modularItem.m_41619_()) {
            int baroffset = 22;
            if (!player.m_7500_()) {
                baroffset += 16;
                int totalArmorValue = player.m_21230_();
                baroffset += 8 * (int)Math.ceil((double)totalArmorValue / 20.0);
            }
            baroffset = screenHeight - baroffset;
            double currX = (double)screenWidth / 2.0 - 89.0 + 20.0 * (double)hotbarIndex;
            double currY = baroffset - 18;
            Color.WHITE.setShaderColor();
            gfx.m_280480_(modularItem, (int)currX, (int)currY);
        }
    }

    public List<Integer> getValidModes();

    public boolean isValidMode(ResourceLocation var1);

    public int getActiveMode();

    public ItemStack getActiveModule();

    public void setActiveMode(int var1);

    public boolean hasActiveModule(ResourceLocation var1);

    public void cycleMode(Player var1, int var2);

    public int nextMode();

    public int prevMode();

    public boolean isModuleActiveAndOnline(ResourceLocation var1);

    default public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand, InteractionResultHolder<ItemStack> fallback) {
        ItemStack fist = player.m_21120_(hand);
        return this.getActiveModule().getCapability(NuminaCapabilities.POWER_MODULE).filter(IRightClickModule.class::isInstance).map(IRightClickModule.class::cast).map(rc -> rc.use(fist, level, player, hand)).orElse(fallback);
    }

    default public int getUseDuration() {
        return this.getActiveModule().getCapability(NuminaCapabilities.POWER_MODULE).map(m -> m.getModuleStack().m_41779_()).orElse(72000);
    }

    default public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context, InteractionResult fallback) {
        return this.getActiveModule().getCapability(NuminaCapabilities.POWER_MODULE).filter(IRightClickModule.class::isInstance).map(IRightClickModule.class::cast).map(m -> m.onItemUseFirst(itemStack, context)).orElse(fallback);
    }

    default public InteractionResult useOn(UseOnContext context, InteractionResult fallback) {
        return this.getActiveModule().getCapability(NuminaCapabilities.POWER_MODULE).filter(IRightClickModule.class::isInstance).map(IRightClickModule.class::cast).map(m -> m.useOn(context)).orElse(fallback);
    }

    default public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        this.getActiveModule().getCapability(NuminaCapabilities.POWER_MODULE).filter(IRightClickModule.class::isInstance).map(IRightClickModule.class::cast).ifPresent(m -> m.releaseUsing(stack, worldIn, entityLiving, timeLeft));
    }

    default public boolean canContinueUsing(@Nonnull ItemStack itemStack) {
        return ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)this.getModularItemStack()) || ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)this.getActiveExternalModule());
    }

    default public boolean onUseTick(Level level, LivingEntity entity, int ticksRemaining) {
        return this.getActiveModule().getCapability(NuminaCapabilities.POWER_MODULE).filter(IOtherModItemsAsModules.class::isInstance).map(IOtherModItemsAsModules.class::cast).map(iOtherModItemsAsModules -> iOtherModItemsAsModules.onUseTick(level, entity, ticksRemaining)).orElse(true);
    }

    default public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        return this.getActiveModule().getCapability(NuminaCapabilities.POWER_MODULE).filter(IMiningEnhancementModule.class::isInstance).map(IMiningEnhancementModule.class::cast).filter(IToggleableModule::isModuleOnline).map(pm -> pm.onBlockStartBreak(itemstack, pos, player)).orElse(false);
    }

    default public boolean mineBlock(ItemStack powerFist, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        double playerEnergy = ElectricItemUtils.getPlayerEnergy(entityLiving);
        return this.getInstalledModulesOfType(IBlockBreakingModule.class).stream().anyMatch(module -> module.getCapability(NuminaCapabilities.POWER_MODULE).filter(IBlockBreakingModule.class::isInstance).map(IBlockBreakingModule.class::cast).map(pm -> pm.mineBlock(powerFist, worldIn, state, pos, entityLiving, playerEnergy)).orElse(false));
    }

    default public float getDestroySpeed(ItemStack pStack, BlockState pState) {
        return this.getInstalledModules().stream().filter(IBlockBreakingModule.class::isInstance).map(IBlockBreakingModule.class::cast).filter(pm -> pm.getEmulatedTool().m_41691_(pState) > 1.0f).max(Comparator.comparing(pm -> Float.valueOf(pm.getEmulatedTool().m_41691_(pState)))).map(pm -> Float.valueOf(pm.getEmulatedTool().m_41691_(pState))).orElse(Float.valueOf(1.0f)).floatValue();
    }

    default public boolean isCorrectToolForDrops(ItemStack itemStack, BlockState state) {
        return this.getInstalledModulesOfType(IBlockBreakingModule.class).stream().anyMatch(module -> module.getCapability(NuminaCapabilities.POWER_MODULE).filter(IBlockBreakingModule.class::isInstance).map(IBlockBreakingModule.class::cast).map(pm -> pm.getEmulatedTool().m_41735_(state)).orElse(false));
    }

    default public ItemStack getActiveExternalModule() {
        return this.getActiveModule().getCapability(NuminaCapabilities.POWER_MODULE).filter(IOtherModItemsAsModules.class::isInstance).map(IOtherModItemsAsModules.class::cast).map(IPowerModule::getModuleStack).orElse(this.getModularItemStack());
    }

    default public boolean returnForeignModuleToModularItem(@Nonnull ItemStack module) {
        int slot = this.findInstalledModule(module);
        Optional<IOtherModItemsAsModules> foreignModuleCap = ItemUtils.getForeignItemAsModuleCap(module);
        if (slot > -1 && foreignModuleCap.isPresent()) {
            this.setStackInSlot(slot, module);
            return true;
        }
        return false;
    }
}

