/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.inventory.modularitem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.CapabilityUpdate;
import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.capabilities.inventory.modularitem.NuminaRangedWrapper;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.tickable.IPlayerTickModule;
import lehjr.numina.common.capabilities.module.toggleable.IToggleableModule;
import lehjr.numina.common.item.ItemUtils;
import lehjr.numina.common.tags.TagUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ModularItem
extends ItemStackHandler
implements IModularItem,
CapabilityUpdate {
    final boolean isTool;
    ItemStack modularItem;
    Map<ModuleCategory, NuminaRangedWrapper> rangedWrappers;
    ModuleTarget target;

    public ModularItem(@Nonnull ItemStack modularItem, int size) {
        this(modularItem, size, false);
    }

    public ModularItem(@Nonnull ItemStack modularItem, int size, boolean isTool) {
        this(modularItem, (NonNullList<ItemStack>)NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_), isTool);
    }

    public ModularItem(@Nonnull ItemStack modularItem, NonNullList<ItemStack> stacks) {
        super(stacks);
        this.modularItem = modularItem;
        this.rangedWrappers = new HashMap<ModuleCategory, NuminaRangedWrapper>();
        this.isTool = false;
    }

    public ModularItem(@Nonnull ItemStack modularItem, NonNullList<ItemStack> stacks, boolean isTool) {
        super(stacks);
        this.modularItem = modularItem;
        this.rangedWrappers = new HashMap<ModuleCategory, NuminaRangedWrapper>();
        this.isTool = isTool;
    }

    @Override
    public void setRangedWrapperMap(Map<ModuleCategory, NuminaRangedWrapper> rangedWrappers) {
        this.rangedWrappers = rangedWrappers;
    }

    @Override
    public void toggleModule(ResourceLocation moduleName, boolean online) {
        int slot = this.findInstalledModule(moduleName);
        if (slot > -1) {
            ItemStack module = this.getStackInSlot(slot);
            module.getCapability(NuminaCapabilities.POWER_MODULE).ifPresent(m -> {
                if (m instanceof IToggleableModule) {
                    ((IToggleableModule)m).toggleModule(online);
                    this.onContentsChanged(slot);
                }
            });
        }
    }

    @Nullable
    public Pair getRangeForCategory(ModuleCategory category) {
        NuminaRangedWrapper rangedWrapper = this.rangedWrappers.get((Object)category);
        if (rangedWrapper != null) {
            return rangedWrapper.getRange();
        }
        return null;
    }

    @Override
    public List<ResourceLocation> getInstalledModuleNames() {
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.m_41619_()) continue;
            locations.add(ItemUtils.getRegistryName(module));
        }
        return locations;
    }

    @Override
    public NonNullList<ItemStack> getInstalledModulesOfType(Class<? extends IPowerModule> type) {
        NonNullList modules = NonNullList.m_122779_();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            module.getCapability(NuminaCapabilities.POWER_MODULE).filter(type::isInstance).ifPresent(pm -> modules.add((Object)module));
        }
        return modules;
    }

    @Override
    public NonNullList<ItemStack> getInstalledModules() {
        NonNullList modules = NonNullList.m_122779_();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.m_41619_()) continue;
            modules.add((Object)module);
        }
        return modules;
    }

    @Override
    public boolean isModuleInstalled(ResourceLocation regName) {
        return this.findInstalledModule(regName) > -1;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack module) {
        return this.getStackLimit(slot, module) > 0;
    }

    @Override
    public boolean isModuleValid(@Nonnull ItemStack module) {
        if (module.m_41619_()) {
            return false;
        }
        return module.getCapability(NuminaCapabilities.POWER_MODULE).map(m -> {
            if (m.isAllowed()) {
                switch (m.getTarget()) {
                    case ALLITEMS: {
                        return true;
                    }
                    case TOOLONLY: {
                        return this.isTool;
                    }
                    case ARMORONLY: {
                        return this.modularItem.m_41720_() instanceof ArmorItem;
                    }
                    case HEADONLY: {
                        return this.modularItem.m_41720_() instanceof ArmorItem && Mob.m_147233_((ItemStack)this.modularItem) == EquipmentSlot.HEAD;
                    }
                    case TORSOONLY: {
                        return this.modularItem.m_41720_() instanceof ArmorItem && Mob.m_147233_((ItemStack)this.modularItem) == EquipmentSlot.CHEST;
                    }
                    case LEGSONLY: {
                        return this.modularItem.m_41720_() instanceof ArmorItem && Mob.m_147233_((ItemStack)this.modularItem) == EquipmentSlot.LEGS;
                    }
                    case FEETONLY: {
                        return this.modularItem.m_41720_() instanceof ArmorItem && Mob.m_147233_((ItemStack)this.modularItem) == EquipmentSlot.FEET;
                    }
                }
                return false;
            }
            return false;
        }).orElse(false);
    }

    @Override
    public boolean isModuleOnline(ResourceLocation moduleName) {
        int slot = this.findInstalledModule(moduleName);
        if (slot > -1) {
            return this.isModuleOnline(this.getStackInSlot(slot));
        }
        return false;
    }

    public boolean isModuleOnline(ItemStack module) {
        return module.getCapability(NuminaCapabilities.POWER_MODULE).map(m -> m.isAllowed() && m.isModuleOnline()).orElse(false);
    }

    @Override
    @Nonnull
    public ItemStack getOnlineModuleOrEmpty(ResourceLocation moduleName) {
        ItemStack module;
        int slot = this.findInstalledModule(moduleName);
        if (slot > -1 && (module = this.getStackInSlot(slot)).getCapability(NuminaCapabilities.POWER_MODULE).map(m -> m.isAllowed() && m.isModuleOnline()).orElse(false).booleanValue()) {
            return module;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void tick(Player player) {
        for (int i = 0; i < this.getSlots(); ++i) {
            this.getStackInSlot(i).getCapability(NuminaCapabilities.POWER_MODULE).filter(IPlayerTickModule.class::isInstance).map(IPlayerTickModule.class::cast).filter(IPowerModule::isAllowed).ifPresent(m -> {
                if (m.isModuleOnline()) {
                    m.onPlayerTickActive(player, this.getModularItemStack());
                } else {
                    m.onPlayerTickInactive(player, this.getModularItemStack());
                }
            });
        }
    }

    @Override
    @Nonnull
    public ItemStack getModularItemStack() {
        return this.modularItem;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack module) {
        if (this.isModuleValid(module)) {
            if (this.isModuleInstalled(ForgeRegistries.ITEMS.getKey((Object)module.m_41720_()))) {
                return 0;
            }
            ModuleCategory category = module.getCapability(NuminaCapabilities.POWER_MODULE).map(m -> m.getCategory()).orElse(ModuleCategory.NONE);
            NuminaRangedWrapper wrapper = this.rangedWrappers.get((Object)category);
            if (wrapper == null) {
                wrapper = this.rangedWrappers.get((Object)ModuleCategory.NONE);
            }
            if (wrapper != null && wrapper.contains(slot)) {
                return wrapper.getStackInSlot(slot).m_41619_() ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public boolean setModuleTweakDouble(ResourceLocation moduleName, String key, double value) {
        boolean handled = false;
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.m_41619_() || !ItemUtils.getRegistryName(module).equals((Object)moduleName) || !module.getCapability(NuminaCapabilities.POWER_MODULE).map(m -> {
                TagUtils.setModuleDoubleOrRemove(module, key, value);
                return true;
            }).orElse(false).booleanValue()) continue;
            this.onContentsChanged(i);
            handled = true;
            break;
        }
        return handled;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.modularItem.m_41700_("MMModItem", (Tag)this.serializeNBT());
    }

    @Override
    public void loadCapValues() {
        CompoundTag nbt = this.getModularItemStack().m_41784_();
        if (nbt.m_128425_("Module Settings", 10)) {
            nbt.m_128365_("MMModItem", Objects.requireNonNull(nbt.m_128423_("Module Settings")));
            nbt.m_128473_("Module Settings");
        }
        if (nbt.m_128441_("MMModItem")) {
            this.deserializeNBT((CompoundTag)nbt.m_128423_("MMModItem"));
        }
    }

    @Override
    public void onValueChanged() {
    }
}

