/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.module.enchantment;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import lehjr.numina.common.capabilities.module.enchantment.IEnchantmentModule;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.tickable.PlayerTickModule;
import lehjr.numina.common.energy.ElectricItemUtils;
import lehjr.numina.common.tags.TagUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class EnchantmentModule
extends PlayerTickModule
implements IEnchantmentModule {
    boolean added;
    boolean removed;

    public EnchantmentModule(@Nonnull ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config, boolean defBool) {
        super(module, category, target, config, defBool);
        this.added = TagUtils.getModuleBooleanOrFalse(module, "added");
        this.removed = TagUtils.getModuleBooleanOrFalse(module, "removed");
    }

    @Override
    public void onPlayerTickActive(Player player, @NotNull ItemStack item) {
        int energyUsage;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        double playerEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)player);
        if (playerEnergy > (double)(energyUsage = this.getEnergyUsage())) {
            this.addEnchantment(item);
            ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, energyUsage);
            this.setAdded(true);
            this.setRemoved(false);
        }
    }

    @Override
    public void onPlayerTickInactive(Player player, @NotNull ItemStack item) {
        if (this.added && !this.removed) {
            this.removeEnchantment(item);
            this.setAdded(false);
            this.setRemoved(true);
        }
    }

    @Override
    public void setAdded(boolean added) {
        this.added = added;
        TagUtils.setModuleBoolean(this.module, "added", added);
    }

    @Override
    public void setRemoved(boolean removed) {
        this.removed = removed;
        TagUtils.setModuleBoolean(this.module, "removed", removed);
    }

    @Override
    public int getLevel() {
        return 1;
    }
}

