/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.render;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.render.IModelSpec;
import lehjr.numina.common.tags.TagUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;

public class ModelSpecStorage
implements IModelSpec,
INBTSerializable<CompoundTag> {
    ItemStack itemStack;

    public ModelSpecStorage(@Nonnull ItemStack itemStackIn) {
        this.itemStack = itemStackIn;
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public CompoundTag setRenderTag(CompoundTag renderDataIn, String tagName) {
        CompoundTag itemTag = TagUtils.getMuseModularItemTag(this.itemStack);
        if (tagName != null) {
            if (Objects.equals(tagName, "render")) {
                itemTag.m_128473_("render");
                if (!renderDataIn.m_128456_()) {
                    itemTag.m_128365_("render", (Tag)renderDataIn);
                } else {
                    itemTag.m_128365_("render", (Tag)new CompoundTag());
                    this.setColorArray(new int[]{-1});
                }
            } else {
                CompoundTag renderTag = !itemTag.m_128441_("render") ? new CompoundTag() : itemTag.m_128469_("render");
                if (renderDataIn.m_128456_()) {
                    renderTag.m_128473_(tagName);
                    renderTag.m_128473_(tagName.replace(".", ""));
                } else {
                    renderTag.m_128365_(tagName, (Tag)renderDataIn);
                }
                itemTag.m_128365_("render", (Tag)renderTag);
            }
        }
        CompoundTag stackTag = this.itemStack.m_41783_();
        stackTag.m_128365_("MMModItem", (Tag)itemTag);
        this.itemStack.m_41751_(stackTag);
        return this.getRenderTag();
    }

    @Override
    @Nullable
    public CompoundTag getRenderTag() {
        CompoundTag itemTag = TagUtils.getMuseModularItemTag(this.itemStack);
        return itemTag.m_128469_("render");
    }

    @Override
    public CompoundTag getDefaultRenderTag() {
        return new CompoundTag();
    }

    @Override
    public List<Integer> addNewColorstoList(List<Integer> colors, List<Integer> colorsToAdd) {
        for (Integer i : colorsToAdd) {
            if (colors.contains(i)) continue;
            colors.add(i);
        }
        return colors;
    }

    @Override
    public int[] getColorArray() {
        return this.getRenderTag().m_128465_("colors");
    }

    @Override
    public int getNewColorIndex(List<Integer> colors, List<Integer> oldColors, Integer index) {
        return colors.indexOf(oldColors.get(index != null ? index : 0));
    }

    @Override
    public CompoundTag setColorArray(int[] colors) {
        this.getRenderTag().m_128385_("colors", colors);
        return this.getRenderTag();
    }

    public CompoundTag serializeNBT() {
        return this.getRenderTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setRenderTag(nbt, "render");
    }
}

