/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.render.modelspec;

import com.mojang.math.Transformation;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import lehjr.numina.client.event.ModelBakeEventHandler;
import lehjr.numina.client.model.obj.OBJBakedCompositeModel;
import lehjr.numina.common.base.NuminaLogger;
import lehjr.numina.common.capabilities.render.modelspec.NuminaModelSpecRegistry;
import lehjr.numina.common.capabilities.render.modelspec.SpecBase;
import lehjr.numina.common.capabilities.render.modelspec.SpecType;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;

public class ObjModelSpec
extends SpecBase {
    private Transformation modelTransform = Transformation.m_121093_();
    private ItemTransforms itemTransforms = ItemTransforms.f_111786_;
    private final ResourceLocation location;

    public ObjModelSpec(ResourceLocation location, String name, boolean isDefault, SpecType specType) {
        this(location, ItemTransforms.f_111786_, name, isDefault, specType);
    }

    public ObjModelSpec(ResourceLocation location, @Nonnull ItemTransforms itemTransforms, String name, boolean isDefault, SpecType specType) {
        super(name, isDefault, specType);
        this.itemTransforms = itemTransforms;
        this.location = location;
    }

    public ItemTransform getTransform(ItemDisplayContext transformType) {
        return this.itemTransforms.m_269404_(transformType);
    }

    public Transformation getModelTransform() {
        return this.modelTransform;
    }

    public void setModelTransform(Transformation modelTransform) {
        this.modelTransform = modelTransform;
    }

    @Override
    public Component getDisaplayName() {
        return Component.m_237115_((String)("model." + this.getOwnName() + ".modelName"));
    }

    @Override
    public String getOwnName() {
        String name = (String)NuminaModelSpecRegistry.getInstance().getName(this);
        return name != null ? name : this.getName();
    }

    @Nonnull
    public Optional<OBJBakedCompositeModel> getModel() {
        BakedModel model = ModelBakeEventHandler.INSTANCE.getBakedItemModel(this.location);
        if (model instanceof OBJBakedCompositeModel) {
            return Optional.of((OBJBakedCompositeModel)model);
        }
        NuminaLogger.logDebug("model at location < " + this.location + " > missing");
        return Optional.empty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjModelSpec objModelSpec = (ObjModelSpec)o;
        return Objects.equals(this.location, objModelSpec.location) && Objects.equals(this.getName(), objModelSpec.getName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.location, this.itemTransforms);
    }
}

