/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.config;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import lehjr.numina.common.base.NuminaLogger;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.config.ConfigHelper;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.io.FileUtils;

public class ModuleConfig
implements IConfig {
    Optional<ModConfig> serverConfig = Optional.empty();
    Map<String, Map<String, ArrayList<String>>> outputMap = new HashMap<String, Map<String, ArrayList<String>>>();
    final String MOD_ID;
    final boolean generateNewConfigValues = false;

    public ModuleConfig(String mod_ID) {
        this.MOD_ID = mod_ID;
    }

    @Override
    public void setServerConfig(@Nullable ModConfig serverConfig) {
        this.serverConfig = Optional.ofNullable(serverConfig);
    }

    @Override
    public Optional<ModConfig> getModConfig() {
        return this.serverConfig;
    }

    boolean isInDevMode() {
        return ModList.get().getModContainerById("numina").map(container -> container.getModInfo().getOwningFile().getFileProperties().isEmpty()).orElse(false);
    }

    void addtoMap(String category, String moduleName, String entry) {
        if (this.getModConfig().isPresent()) {
            ArrayList moduleSettings;
            Map<Object, Object> modulesForCategory;
            NuminaLogger.logDebug("adding to map: " + category + ", " + moduleName + ", " + entry);
            if (this.outputMap.containsKey(category)) {
                modulesForCategory = this.outputMap.get(category);
                if (modulesForCategory.containsKey(moduleName)) {
                    moduleSettings = (ArrayList)modulesForCategory.get(moduleName);
                    if (moduleSettings.contains(entry)) {
                        return;
                    }
                } else {
                    moduleSettings = new ArrayList();
                }
            } else {
                modulesForCategory = new HashMap();
                moduleSettings = new ArrayList();
            }
            moduleSettings.add(entry);
            modulesForCategory.put(moduleName, moduleSettings);
            this.outputMap.put(category, modulesForCategory);
        }
    }

    public void writeMissingConfigValues() {
        if (this.outputMap.isEmpty() || !this.isInDevMode()) {
            return;
        }
        this.getModConfig().ifPresent(config -> NuminaLogger.logDebug("configData for " + this.MOD_ID + ": " + config.getConfigData()));
        NuminaLogger.logDebug("MODULE MAP SET SIZE: " + this.outputMap.size());
        StringBuilder outString = new StringBuilder("builder.push(\"Modules\");\n");
        for (Map.Entry<String, Map<String, ArrayList<String>>> categoryMapEntry : this.outputMap.entrySet()) {
            String moduleCategory = categoryMapEntry.getKey();
            outString.append("builder.push(\"").append(moduleCategory).append("\");\n");
            Map<String, ArrayList<String>> moduleMapEntry = categoryMapEntry.getValue();
            for (Map.Entry<String, ArrayList<String>> entry : moduleMapEntry.entrySet()) {
                String moduleName = entry.getKey();
                ArrayList<String> moduleSettings = entry.getValue();
                outString.append("builder.push(\"").append(moduleName).append("\");\n");
                for (String moduleLine : moduleSettings) {
                    outString.append(moduleLine);
                }
                outString.append("builder.pop();\n");
            }
            outString.append("builder.pop();\n");
        }
        outString.append("builder.pop();\n");
        try {
            FileUtils.writeStringToFile((File)ConfigHelper.setupConfigFile("missingConfigs.txt", this.MOD_ID), (String)outString.toString(), (Charset)Charset.defaultCharset(), (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public double getBasePropertyDoubleOrDefault(ImmutableList<String> configKey, double baseVal) {
        if (this.isInDevMode()) {
            // empty if block
        }
        return (Double)this.getModConfig().map(config -> {
            if (config.getConfigData() != null) {
                Object object = config.getConfigData().getOrElse((List)configKey, (Object)baseVal);
                if (object != null && object instanceof Integer) {
                    int i = (Integer)object;
                    return (double)i;
                }
                if (object instanceof Double) {
                    return object;
                }
                return baseVal;
            }
            return baseVal;
        }).orElse(baseVal);
    }

    @Override
    public double getTradeoffPropertyDoubleOrDefault(ImmutableList<String> configKey, double multiplier) {
        if (this.isInDevMode()) {
            // empty if block
        }
        return (Double)this.getModConfig().map(config -> {
            if (config.getConfigData() != null) {
                Object object = config.getConfigData().getOrElse((List)configKey, (Object)multiplier);
                if (object != null && object instanceof Integer) {
                    int i = (Integer)object;
                    return (double)i;
                }
                if (object instanceof Double) {
                    return object;
                }
                return multiplier;
            }
            return multiplier;
        }).orElse(multiplier);
    }

    @Override
    public int getTradeoffPropertyIntegerOrDefault(ImmutableList<String> configKey, int multiplier) {
        if (this.isInDevMode()) {
            // empty if block
        }
        return (Integer)this.getModConfig().map(config -> {
            if (config.getConfigData() != null) {
                Object object = config.getConfigData().getOrElse((List)configKey, (Object)multiplier);
                if (object != null && object instanceof Integer) {
                    return object;
                }
                if (object instanceof Double) {
                    double i = (Double)object;
                    return i;
                }
                return multiplier;
            }
            return multiplier;
        }).orElse(multiplier);
    }

    @Override
    public boolean isModuleAllowed(ImmutableList<String> key) {
        if (this.isInDevMode()) {
            // empty if block
        }
        return this.getModConfig().map(config -> {
            if (config.getConfigData() != null) {
                return (Boolean)config.getConfigData().getOrElse((List)key, (Object)true);
            }
            return true;
        }).orElse(true);
    }

    ImmutableList<String> getIsAllowed(ImmutableList<String> configKey) {
        return ImmutableList.of((Object)((String)configKey.get(0)), (Object)((String)configKey.get(1)), (Object)((String)configKey.get(2)), (Object)"isAllowed");
    }

    @Override
    public boolean getGenericBooleanProperty(ImmutableList<String> key) {
        if (this.isInDevMode()) {
            // empty if block
        }
        return this.getModConfig().map(config -> {
            if (config.getConfigData() != null) {
                return (Boolean)config.getConfigData().getOrElse((List)key, (Object)true);
            }
            return true;
        }).orElse(true);
    }
}

