/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.container;

import com.mojang.blaze3d.vertex.PoseStack;
import lehjr.numina.client.gui.slot.IconSlotItemHandler;
import lehjr.numina.client.render.IconUtils;
import lehjr.numina.common.base.NuminaObjects;
import lehjr.numina.common.blockentity.ChargingBaseBlockEntity;
import lehjr.numina.common.capabilities.energy.BlockEnergyStorage;
import lehjr.numina.common.math.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ChargingBaseMenu
extends AbstractContainerMenu {
    private BlockEntity blockEntity;
    private Player player;
    private IItemHandler playerInventory;

    public ChargingBaseMenu(int windowID, BlockPos pos, Inventory playerInventory) {
        super((MenuType)NuminaObjects.CHARGING_BASE_CONTAINER_TYPE.get(), windowID);
        Slot slot;
        int col;
        this.player = playerInventory.f_35978_;
        this.blockEntity = this.player.m_9236_().m_7702_(pos);
        this.playerInventory = new InvWrapper((Container)playerInventory);
        if (this.blockEntity != null) {
            this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> this.m_38897_((Slot)new IconSlotItemHandler((IItemHandler)h, 0, 79, 35){

                @Override
                public void drawIconAt(PoseStack matrixStack, double posX, double posY, Color color) {
                    IconUtils.INSTANCE.getIcon().energystorage.renderIconScaledWithColor(matrixStack, posX, posY, 16.0, 16.0, Color.WHITE);
                }
            }));
        }
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                slot = this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            slot = this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
        this.trackPower();
    }

    private void trackPower() {
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return ChargingBaseMenu.this.getBlockEnergy() & 0xFFFF;
            }

            public void m_6422_(int value) {
                if (ChargingBaseMenu.this.blockEntity instanceof ChargingBaseBlockEntity) {
                    ((ChargingBaseBlockEntity)ChargingBaseMenu.this.blockEntity).getBlockEnergyHandler().ifPresent(h -> {
                        int energyStored = h.getEnergyStored() & 0xFFFF0000;
                        ((BlockEnergyStorage)h).setEnergy(energyStored + (value & 0xFFFF));
                    });
                }
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return ChargingBaseMenu.this.getBlockEnergy() >> 16 & 0xFFFF;
            }

            public void m_6422_(int value) {
                if (ChargingBaseMenu.this.blockEntity instanceof ChargingBaseBlockEntity) {
                    ((ChargingBaseBlockEntity)ChargingBaseMenu.this.blockEntity).getBlockEnergyHandler().ifPresent(h -> {
                        int energyStored = h.getEnergyStored() & 0xFFFF;
                        ((BlockEnergyStorage)h).setEnergy(energyStored | value << 16);
                    });
                }
            }
        });
    }

    public int getEnergy() {
        return this.blockEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public int getMaxEnergy() {
        return this.blockEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
    }

    public float getEnergyForMeter() {
        return this.blockEntity.getCapability(ForgeCapabilities.ENERGY).map(energy -> Float.valueOf((float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public int getBlockEnergy() {
        return this.blockEntity instanceof ChargingBaseBlockEntity ? ((ChargingBaseBlockEntity)this.blockEntity).getBlockEnergyHandler().map(IEnergyStorage::getEnergyStored).orElse(0) : 0;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(stack, 1, 37, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack, itemstack);
            } else if (this.blockEntity != null && this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).map(h -> h.isItemValid(0, stack)).orElse(false) != false ? !this.m_38903_(stack, 0, 1, false) : (index < 28 ? !this.m_38903_(stack, 28, 37, false) : index < 37 && !this.m_38903_(stack, 1, 28, false))) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, stack);
        }
        return itemstack;
    }

    public boolean m_6875_(Player playerIn) {
        return ChargingBaseMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_()), (Player)this.player, (Block)((Block)NuminaObjects.CHARGING_BASE_BLOCK.get()));
    }
}

