/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.ModLifecycleEvent;

public class EventBusHelper {
    private static final Map<Object, List<Subscription>> subscriptions = new HashMap<Object, List<Subscription>>();

    private static IEventBus getInstance() {
        return MinecraftForge.EVENT_BUS;
    }

    public static <T extends Event> void addListener(Object owner, IEventBus eventBus, Class<T> eventType, Consumer<T> listener) {
        subscriptions.computeIfAbsent(owner, e -> new ArrayList()).add(new Subscription(eventBus, listener));
        eventBus.addListener(EventPriority.NORMAL, false, eventType, listener);
    }

    public static <T extends ModLifecycleEvent> void addLifecycleListener(Object owner, IEventBus eventBus, Class<T> eventType, Consumer<T> listener) {
        EventBusHelper.addListener(owner, eventBus, eventType, listener);
    }

    public static void register(Object owner) {
        IEventBus eventBus = EventBusHelper.getInstance();
        subscriptions.putIfAbsent(owner, new ArrayList());
        eventBus.register(owner);
    }

    private static class Subscription {
        private final IEventBus eventBus;
        private final Consumer<? extends Event> listener;

        private <T extends Event> Subscription(IEventBus eventBus, Consumer<T> listener) {
            this.eventBus = eventBus;
            this.listener = listener;
        }
    }
}

