/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.capabilities.inventory.modechanging.IModeChangingItem;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.capabilities.module.externalitems.IOtherModItemsAsModules;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUtils {
    public static NonNullList<ItemStack> getModularItemsEquipped(Player player) {
        NonNullList modulars = NonNullList.m_122779_();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemStack = player.m_6844_(slot);
            itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(handler -> {
                switch (slot.m_20743_()) {
                    case HAND: {
                        if (handler instanceof IModeChangingItem) {
                            modulars.add((Object)itemStack);
                        }
                    }
                    case ARMOR: {
                        modulars.add((Object)itemStack);
                    }
                }
            });
        }
        return modulars;
    }

    public static NonNullList<ItemStack> getModularItemsInInventory(Player player) {
        return ItemUtils.getModularItemsInInventory(player.m_150109_());
    }

    public static NonNullList<ItemStack> getModularItemsInInventory(Inventory inv) {
        NonNullList stacks = NonNullList.m_122779_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemStack = inv.m_8020_(i);
            itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(handler -> stacks.add((Object)itemStack));
        }
        return stacks;
    }

    public static List<Integer> getModularItemSlotsEquiped(Player player) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        player.m_21205_().getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).ifPresent(handler -> slots.add(player.m_150109_().f_35977_));
        for (int i = 36; i < player.m_150109_().m_6643_(); ++i) {
            int index = i;
            player.m_150109_().m_8020_(i).getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(handler -> slots.add(index));
        }
        return slots;
    }

    public static List<Integer> getModularItemSlotsInInventory(Player player) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            int finalI = i;
            player.m_150109_().m_8020_(i).getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(handler -> slots.add(finalI));
        }
        return slots;
    }

    public static ItemStack getActiveModuleOrEmpty(@Nonnull ItemStack itemStack) {
        return itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).map(iModeChangingItem -> iModeChangingItem.getActiveModule()).orElse(ItemStack.f_41583_);
    }

    public static ResourceLocation getRegistryName(@Nonnull ItemStack itemStack) {
        return ItemUtils.getRegistryName(itemStack.m_41720_());
    }

    @Nonnull
    public static ItemStack getItemFromEntitySlot(LivingEntity entity, EquipmentSlot slot) {
        if (entity == null) {
            return ItemStack.f_41583_;
        }
        return entity.m_6844_(slot);
    }

    @Nonnull
    public static ItemStack getItemFromEntityHand(LivingEntity entity, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return ItemUtils.getItemFromEntitySlot(entity, EquipmentSlot.MAINHAND);
        }
        return ItemUtils.getItemFromEntitySlot(entity, EquipmentSlot.OFFHAND);
    }

    public static ResourceLocation getRegistryName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static void setModeAndSwapIfNeeded(Player player, int mode) {
        int selected = player.m_150109_().f_35977_;
        ItemStack itemStack = player.m_150109_().m_36056_();
        ItemStack stackToSet = ItemStack.f_41583_;
        Optional<IOtherModItemsAsModules> foreignModuleCap = ItemUtils.getForeignItemAsModuleCap(itemStack);
        Optional<IModeChangingItem> mciCap = ItemUtils.getModeChangingModularItemCapability(itemStack);
        if (foreignModuleCap.isPresent()) {
            ItemStack host = foreignModuleCap.get().retrieveHostStack();
            mciCap = ItemUtils.getModeChangingModularItemCapability(host);
            if (mciCap.isPresent() && mciCap.get().returnForeignModuleToModularItem(itemStack)) {
                mciCap.get().setActiveMode(mode);
                ItemStack newModule = mciCap.get().getActiveModule();
                Optional<IOtherModItemsAsModules> foreignModuleCap1 = ItemUtils.getForeignItemAsModuleCap(newModule);
                if (foreignModuleCap1.isPresent()) {
                    foreignModuleCap1.get().storeHostStack(host.m_41777_());
                    stackToSet = newModule.m_41777_();
                } else {
                    stackToSet = host;
                }
            }
        } else if (mciCap.isPresent()) {
            mciCap.get().setActiveMode(mode);
            ItemStack newModule = mciCap.get().getActiveModule();
            Optional<IOtherModItemsAsModules> foreignModuleCap1 = ItemUtils.getForeignItemAsModuleCap(newModule);
            if (foreignModuleCap1.isPresent()) {
                foreignModuleCap1.get().storeHostStack(itemStack.m_41777_());
                stackToSet = newModule;
            } else {
                stackToSet = mciCap.get().getModularItemStack();
            }
        }
        player.m_150109_().m_6836_(selected, stackToSet);
        player.f_36096_.m_38946_();
    }

    public static Optional<IOtherModItemsAsModules> getForeignItemAsModuleCap(@Nonnull ItemStack module) {
        return module.getCapability(NuminaCapabilities.POWER_MODULE).filter(m -> m.isAllowed() && m instanceof IOtherModItemsAsModules).map(IOtherModItemsAsModules.class::cast);
    }

    public static Optional<IModeChangingItem> getModeChangingModularItemCapability(Player player) {
        ItemStack itemStack = player.m_150109_().m_36056_();
        Optional<IModeChangingItem> mcItemCap = ItemUtils.getModeChangingModularItemCapability(itemStack);
        if (mcItemCap.isPresent()) {
            return mcItemCap;
        }
        Optional<IOtherModItemsAsModules> foreignModuleCap = ItemUtils.getForeignItemAsModuleCap(itemStack);
        if (foreignModuleCap.isPresent()) {
            return foreignModuleCap.get().getStoredModeChangingModuleCapInStorage();
        }
        return Optional.empty();
    }

    public static Optional<IModeChangingItem> getModeChangingModularItemCapability(@Nonnull ItemStack modularItem) {
        return modularItem.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast);
    }
}

