/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.map;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.stream.Stream;
import lehjr.numina.common.base.NuminaLogger;

public class NuminaBiMap<S, T> {
    private BiMap<S, T> theMap = HashBiMap.create();

    public T get(S name) {
        return (T)this.theMap.get(name);
    }

    public Iterable<T> elems() {
        return this.theMap.values();
    }

    public Stream<T> elemsAsStream() {
        return this.theMap.values().stream();
    }

    public Iterable<S> names() {
        return this.theMap.keySet();
    }

    public Stream<S> namessAsStream() {
        return this.theMap.keySet().stream();
    }

    public T putName(S name, T elem) {
        if (this.theMap.containsKey(name)) {
            NuminaLogger.logError(name + " already a member!");
        } else {
            this.theMap.put(name, elem);
        }
        return elem;
    }

    public S putElem(T elem, S name) {
        if (this.theMap.containsKey(name)) {
            NuminaLogger.logError(name + " already a member!");
        } else {
            this.theMap.put(name, elem);
        }
        return name;
    }

    public Map<S, T> apply() {
        return this.theMap;
    }

    public Map<T, S> inverse() {
        return this.theMap.inverse();
    }

    public S getName(T elem) {
        return (S)this.theMap.inverse().get(elem);
    }

    public S removeElem(T elem) {
        return (S)this.theMap.inverse().remove(elem);
    }

    public T removeName(S name) {
        return (T)this.theMap.remove(name);
    }
}

