/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.math;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import lehjr.numina.common.base.NuminaLogger;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Vector4f;

public class Color {
    public static final float div255 = 0.003921569f;
    public static final Color WHITE = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Color LIGHT_GRAY = new Color(0.753f, 0.753f, 0.753f, 1.0f);
    public static final Color GREY = new Color(0.502f, 0.502f, 0.502f, 1.0f);
    public static final Color DARK_GRAY = new Color(0.251f, 0.251f, 0.251f, 1.0f);
    public static final Color GREY_GUI_BACKGROUND = new Color(0.776f, 0.776f, 0.776f, 1.0f);
    public static final Color BLACK = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Color RED = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    public static final Color PINK = new Color(1.0f, 0.686f, 0.686f, 1.0f);
    public static final Color ORANGE = new Color(1.0f, 0.7843f, 0.0f, 1.0f);
    public static final Color YELLOW = new Color(1.0f, 1.0f, 0.0f, 1.0f);
    public static final Color GREEN = new Color(0.0f, 1.0f, 0.0f, 1.0f);
    public static final Color LIGHT_GREEN = new Color(0.5f, 1.0f, 0.5f, 1.0f);
    public static final Color DARK_GREEN = new Color(0.0f, 0.8f, 0.2f, 1.0f);
    public static final Color MAGENTA = new Color(1.0f, 0.0f, 1.0f, 1.0f);
    public static final Color CYAN = new Color(0.0f, 1.0f, 1.0f, 1.0f);
    public static final Color BLUE = new Color(0.0f, 0.0f, 1.0f, 1.0f);
    public static final Color LIGHT_BLUE = new Color(0.5f, 0.5f, 1.0f, 1.0f);
    public static final Color DARKBLUE = new Color(0.0f, 0.0f, 0.5f, 1.0f);
    public static final Color PURPLE = new Color(0.6f, 0.1f, 0.9f, 1.0f);
    public final float r;
    public final float g;
    public final float b;
    public final float a;

    public Color(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Color(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = 1.0f;
    }

    public Color(Vector4f vec4fColor) {
        this.r = vec4fColor.x();
        this.g = vec4fColor.y();
        this.b = vec4fColor.z();
        this.a = vec4fColor.w();
    }

    public Color(int r, int g, int b) {
        this.r = (float)r * 0.003921569f;
        this.g = (float)g * 0.003921569f;
        this.b = (float)b * 0.003921569f;
        this.a = 1.0f;
    }

    public void setGuiGraphicsColor(GuiGraphics gfx) {
        gfx.m_280246_(this.r, this.g, this.b, this.a);
    }

    public VertexConsumer addToVertex(VertexConsumer builderIn) {
        return builderIn.m_85950_(this.r, this.g, this.b, this.a);
    }

    public Vector4f getVec4F() {
        return new Vector4f(this.r, this.g, this.b, this.a);
    }

    public Color(int c) {
        this.a = (float)(c >> 24 & 0xFF) * 0.003921569f;
        this.r = (float)(c >> 16 & 0xFF) * 0.003921569f;
        this.g = (float)(c >> 8 & 0xFF) * 0.003921569f;
        this.b = (float)(c & 0xFF) * 0.003921569f;
    }

    public Color lighten(float amount) {
        float r = Math.min(this.r + amount, 1.0f);
        float g = Math.min(this.g + amount, 1.0f);
        float b = Math.min(this.b + amount, 1.0f);
        return new Color(r, g, b, this.a);
    }

    public Color darken(float amount) {
        float r = Math.max(this.r - amount, 0.0f);
        float g = Math.max(this.g - amount, 0.0f);
        float b = Math.max(this.b - amount, 0.0f);
        return new Color(r, g, b, this.a);
    }

    public static int getARGBInt(float r, float g, float b, float a) {
        int val = 0;
        val |= (int)(a * 255.0f) << 24;
        val |= (int)(r * 255.0f) << 16;
        val |= (int)(g * 255.0f) << 8;
        return val |= (int)(b * 255.0f);
    }

    public int getAGBRInt() {
        int val = 0;
        val |= (int)(this.a * 255.0f) << 24;
        val |= (int)(this.g * 255.0f) << 16;
        val |= (int)(this.b * 255.0f) << 8;
        return val |= (int)(this.r * 255.0f);
    }

    public void setShaderColor() {
        RenderSystem.setShaderColor((float)this.r, (float)this.g, (float)this.b, (float)this.a);
    }

    public static Color getGreyscale(float value, float alpha) {
        return new Color(value, value, value, alpha);
    }

    public static Color fromARGBHexString(String hexString) {
        try {
            if (hexString == null || hexString.isEmpty()) {
                return WHITE;
            }
            hexString = hexString.replaceAll("#", "");
            int parsed = (int)Long.parseLong(hexString, 16);
            Color color = new Color((int)Long.parseLong(hexString, 16));
            if (color.a == 0.0f) {
                return color.withAlpha(1.0f);
            }
            return color;
        }
        catch (Exception e) {
            NuminaLogger.logException("Failed to generate color from Hex: ", e);
            return WHITE;
        }
    }

    public int getARGBInt() {
        int val = 0;
        val |= (int)(this.a * 255.0f) << 24;
        val |= (int)(this.r * 255.0f) << 16;
        val |= (int)(this.g * 255.0f) << 8;
        return val |= (int)(this.b * 255.0f);
    }

    public Color interpolate(Color target, float d) {
        float complement = 1.0f - d;
        return new Color(this.r * complement + target.r * d, this.g * complement + target.g * d, this.b * complement + target.b * d, this.a * complement + target.a * d);
    }

    public Color withAlpha(float newalpha) {
        return new Color(this.r, this.g, this.b, newalpha);
    }

    public float[] asFloatArray() {
        return new float[]{this.r, this.g, this.b, this.a};
    }

    public double[] asDoubleArray() {
        return new double[]{this.r, this.g, this.b, this.a};
    }

    public String rgbaHexColor() {
        return Color.hexDigits(this.r) + Color.hexDigits(this.g) + Color.hexDigits(this.b) + (this.a > 0.0f ? Color.hexDigits(this.a) : "");
    }

    public static String hexDigits(float x) {
        int y = (int)(x * 255.0f);
        String hexDigits = "0123456789ABCDEF";
        return "" + hexDigits.charAt(y / 16) + hexDigits.charAt(y % 16);
    }

    public String toString() {
        return "Color{r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        return Double.compare(color.r, this.r) == 0 && Double.compare(color.g, this.g) == 0 && Double.compare(color.b, this.b) == 0 && Double.compare(color.a, this.a) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.a));
    }

    public Color copy() {
        return new Color(this.r, this.g, this.b, this.a);
    }
}

