/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.network.packets.serverbound;

import java.util.function.Supplier;
import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.item.ItemUtils;
import lehjr.numina.common.network.NuminaPackets;
import lehjr.numina.common.network.packets.clientbound.ColorInfoPacketClientBound;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record ColorInfoPacketServerBound(EquipmentSlot slotType, int[] tagData) {
    public static void encode(ColorInfoPacketServerBound msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130068_((Enum)msg.slotType);
        packetBuffer.m_130089_(msg.tagData);
    }

    public static ColorInfoPacketServerBound decode(FriendlyByteBuf packetBuffer) {
        return new ColorInfoPacketServerBound((EquipmentSlot)packetBuffer.m_130066_(EquipmentSlot.class), packetBuffer.m_130100_());
    }

    public static void sendToClient(ServerPlayer entity, EquipmentSlot slotType, int[] tagData) {
        NuminaPackets.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> entity), (Object)new ColorInfoPacketClientBound(slotType, tagData));
    }

    public static class Handler {
        public static void handle(ColorInfoPacketServerBound message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                EquipmentSlot slotType = message.slotType;
                int[] tagData = message.tagData;
                ItemUtils.getItemFromEntitySlot((LivingEntity)player, slotType).getCapability(NuminaCapabilities.RENDER).ifPresent(render -> render.setColorArray(tagData));
                ColorInfoPacketServerBound.sendToClient(player, slotType, tagData);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

