/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.network.packets.serverbound;

import java.util.function.Supplier;
import lehjr.numina.common.item.ItemUtils;
import lehjr.numina.common.network.NuminaPackets;
import lehjr.numina.common.network.packets.clientbound.ModeChangeRequestPacketClientBound;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record ModeChangeRequestPacketServerBound(int mode) {
    public static void encode(ModeChangeRequestPacketServerBound msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.mode);
    }

    public static ModeChangeRequestPacketServerBound decode(FriendlyByteBuf packetBuffer) {
        return new ModeChangeRequestPacketServerBound(packetBuffer.readInt());
    }

    public static void sendToClient(ServerPlayer entity, int mode) {
        NuminaPackets.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> entity), (Object)new ModeChangeRequestPacketClientBound(mode));
    }

    public static class Handler {
        public static void handle(ModeChangeRequestPacketServerBound message, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            ctx.get().enqueueWork(() -> {
                int mode = message.mode;
                if (player != null) {
                    ItemUtils.setModeAndSwapIfNeeded((Player)player, mode);
                    if (player instanceof ServerPlayer) {
                        ModeChangeRequestPacketServerBound.sendToClient(player, mode);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

