/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.recipe;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.recipe.RecipeSerializersRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ShapedEnchantmentRecipe
extends ShapedRecipe {
    public ShapedEnchantmentRecipe(ResourceLocation pId, String pGroup, CraftingBookCategory pCategory, int pWidth, int pHeight, NonNullList<Ingredient> pRecipeItems, ItemStack pResult) {
        super(pId, pGroup, pCategory, pWidth, pHeight, pRecipeItems, pResult, true);
    }

    public ShapedEnchantmentRecipe(ShapedRecipe shaped) {
        super(shaped.m_6423_(), shaped.m_6076_(), shaped.m_245232_(), shaped.m_44220_(), shaped.getRecipeHeight(), shaped.m_7527_(), shaped.m_8043_(null), shaped.m_271738_());
    }

    public ItemStack m_5874_(CraftingContainer container, RegistryAccess registryAccess) {
        return super.m_5874_(container, registryAccess);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializersRegistry.ENCHANTMENT_RECIPE_SERIALIZER.get();
    }

    public static ItemStack enchantmentFixer(@Nonnull ItemStack itemStack) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)itemStack);
        ListTag listTag = itemStack.m_41785_();
        for (Tag tag : listTag) {
            if (!(tag instanceof CompoundTag)) continue;
            ResourceLocation enchantmentID = EnchantmentHelper.m_182446_((CompoundTag)((CompoundTag)tag));
            int lvl = ((CompoundTag)tag).m_128441_("lvl") ? ((CompoundTag)tag).m_128451_("lvl") : 1;
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantmentID);
            enchantments.put(enchantment, lvl);
        }
        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)itemStack);
        return itemStack;
    }

    public boolean m_44170_(CraftingContainer pCraftingInventory, int pWidth, int pHeight, boolean pMirrored) {
        for (int i = 0; i < pCraftingInventory.m_39347_(); ++i) {
            for (int j = 0; j < pCraftingInventory.m_39346_(); ++j) {
                ItemStack testStack;
                int k = i - pWidth;
                int l = j - pHeight;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.f_44146_ && l < this.f_44147_) {
                    ingredient = pMirrored ? (Ingredient)this.f_44148_.get(this.f_44146_ - k - 1 + l * this.f_44146_) : (Ingredient)this.f_44148_.get(k + l * this.f_44146_);
                }
                if (this.test(testStack = pCraftingInventory.m_8020_(i + j * pCraftingInventory.m_39347_()), ingredient)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean test(@Nullable ItemStack testStack, Ingredient ingredient) {
        Map testStackEnchantments = EnchantmentHelper.m_44831_((ItemStack)testStack);
        if (testStack == null) {
            return false;
        }
        if (ingredient.m_43908_().length == 0) {
            return testStack.m_41619_();
        }
        for (ItemStack itemstack : ingredient.m_43908_()) {
            Map ingredientStackEnchantments = EnchantmentHelper.m_44831_((ItemStack)itemstack);
            if (ingredientStackEnchantments.size() > 0 && testStackEnchantments.size() > 0) {
                boolean match = true;
                for (Enchantment enchantment : ingredientStackEnchantments.keySet()) {
                    if (ingredientStackEnchantments.getOrDefault(enchantment, 1) <= testStackEnchantments.getOrDefault(enchantment, 0)) continue;
                    match = false;
                }
                return match;
            }
            if (!itemstack.m_150930_(testStack.m_41720_())) continue;
            return true;
        }
        return false;
    }

    static Map<String, Ingredient> m_44210_(JsonObject pKeyEntry) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : pKeyEntry.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            if (((JsonElement)entry.getValue()).toString().contains("StoredEnchantments")) {
                Ingredient ing;
                JsonElement element = (JsonElement)entry.getValue();
                if (element instanceof JsonObject) {
                    ItemStack ingStack = ShapedEnchantmentRecipe.m_151274_((JsonObject)((JsonObject)element));
                    ingStack = ShapedEnchantmentRecipe.enchantmentFixer(ingStack);
                    ing = Ingredient.m_43927_((ItemStack[])new ItemStack[]{ingStack});
                } else {
                    ing = Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue()));
                }
                map.put((String)entry.getKey(), ing);
                continue;
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static class EnchantmentSerializer
    extends ShapedRecipe.Serializer {
        public ShapedEnchantmentRecipe fromJson(ResourceLocation id, JsonObject pJson) {
            String group = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
            Map<String, Ingredient> map = ShapedEnchantmentRecipe.m_44210_(GsonHelper.m_13930_((JsonObject)pJson, (String)"key"));
            String[] astring = ShapedRecipe.m_44186_((String[])ShapedRecipe.m_44196_((JsonArray)GsonHelper.m_13933_((JsonObject)pJson, (String)"pattern")));
            int width = astring[0].length();
            int height = astring.length;
            NonNullList ingredients = ShapedRecipe.m_44202_((String[])astring, map, (int)width, (int)height);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
            return new ShapedEnchantmentRecipe(id, group, CraftingBookCategory.EQUIPMENT, width, height, (NonNullList<Ingredient>)ingredients, result);
        }
    }
}

