/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.string;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.capabilities.inventory.modechanging.IModeChangingItem;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.constants.NuminaConstants;
import lehjr.numina.common.string.StringUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class AdditionalInfo {
    public static void appendHoverText(@Nonnull ItemStack stack, Level worldIn, List currentTipList, TooltipFlag advancedToolTips) {
        if (worldIn == null) {
            return;
        }
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(iItemHandler -> {
            if (iItemHandler instanceof IModeChangingItem) {
                ItemStack activeModule = ((IModeChangingItem)iItemHandler).getActiveModule();
                if (!activeModule.m_41619_()) {
                    MutableComponent localizedName = (MutableComponent)activeModule.m_41611_();
                    currentTipList.add(Component.m_237115_((String)NuminaConstants.TOOLTIP_MODE).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)localizedName.m_6270_(Style.f_131099_.m_131157_(ChatFormatting.RED))));
                } else {
                    currentTipList.add(Component.m_237115_((String)NuminaConstants.TOOLTIP_CHANGE_MODES));
                }
            }
            if (AdditionalInfo.doAdditionalInfo()) {
                ArrayList<MutableComponent> installed = new ArrayList<MutableComponent>();
                HashMap fluids = new HashMap();
                for (ItemStack module : iItemHandler.getInstalledModules()) {
                    installed.add(((MutableComponent)module.m_41611_()).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.LIGHT_PURPLE)));
                    module.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> {
                        int numTanks = fluidHandler.getTanks();
                        for (int i = 0; i < numTanks; ++i) {
                            FluidStack fluidStack = fluidHandler.getFluidInTank(i);
                            if (fluidStack.isEmpty()) continue;
                            int capacity = fluidHandler.getTankCapacity(i);
                            Component fluidName = fluidHandler.getFluidInTank(i).getDisplayName();
                            FluidInfo fluidInfo = fluids.getOrDefault(fluidName, new FluidInfo(fluidName)).addAmmount(fluidStack.getAmount()).addMax(capacity);
                            fluids.put(fluidName, fluidInfo);
                        }
                    });
                }
                if (fluids.size() > 0) {
                    for (FluidInfo info : fluids.values()) {
                        currentTipList.add(info.getOutput());
                    }
                }
                if (installed.size() == 0) {
                    MutableComponent message = Component.m_237115_((String)NuminaConstants.TOOLTIP_NO_MODULES);
                    currentTipList.addAll(StringUtils.wrapComponentToLength((Component)message, 30));
                } else {
                    currentTipList.add(Component.m_237115_((String)NuminaConstants.TOOLTIP_INSTALLED_MODULES));
                    currentTipList.addAll(installed);
                }
            } else {
                currentTipList.add(AdditionalInfo.additionalInfoInstructions());
            }
        });
        stack.getCapability(NuminaCapabilities.POWER_MODULE).ifPresent(iPowerModule -> {
            if (AdditionalInfo.doAdditionalInfo()) {
                MutableComponent description = Component.m_237115_((String)(stack.m_41720_().m_5524_() + ".desc"));
                currentTipList.addAll(StringUtils.wrapComponentToLength((Component)description, 30));
            } else {
                currentTipList.add(AdditionalInfo.additionalInfoInstructions());
            }
        });
        stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyCap -> currentTipList.add(Component.m_237113_((String)I18n.m_118938_((String)NuminaConstants.TOOLTIP_BATTERY_ENERGY, (Object[])new Object[]{StringUtils.formatNumberShort(energyCap.getEnergyStored()), StringUtils.formatNumberShort(energyCap.getMaxEnergyStored())})).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.AQUA).m_131155_(Boolean.valueOf(true)))));
    }

    public static Component additionalInfoInstructions() {
        return Component.m_237115_((String)NuminaConstants.TOOLTIP_PRESS_SHIFT).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true)));
    }

    public static List<Component> getItemInstalledModules(@Nonnull ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(iItemHandler -> {
            ArrayList<MutableComponent> moduleNames = new ArrayList<MutableComponent>();
            for (ItemStack module : iItemHandler.getInstalledModules()) {
                moduleNames.add(((MutableComponent)module.m_41611_()).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.LIGHT_PURPLE)));
            }
            return moduleNames;
        }).orElse(new ArrayList());
    }

    public static boolean doAdditionalInfo() {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340);
    }

    static class FluidInfo {
        Component displayName;
        int currentAmount = 0;
        int maxAmount = 0;

        FluidInfo(Component displayName) {
            this.displayName = displayName;
        }

        public Component getDisplayName() {
            return this.displayName;
        }

        public int getMaxAmount() {
            return this.maxAmount;
        }

        public int getCurrentAmount() {
            return this.currentAmount;
        }

        public FluidInfo addMax(int maxAmountIn) {
            this.maxAmount += maxAmountIn;
            return this;
        }

        public FluidInfo addAmmount(int currentAmountIn) {
            this.currentAmount += currentAmountIn;
            return this;
        }

        public Component getOutput() {
            return this.displayName.m_6881_().m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237113_((String)new StringBuilder(this.currentAmount).append("/").append(this.maxAmount).toString())).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_AQUA).m_131155_(Boolean.valueOf(true)));
        }
    }
}

