/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.string;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lehjr.numina.common.math.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class StringUtils {
    public static final char[] smallSuffixes = new char[]{'m', '\u03bc', 'n', 'p', 'f', 'a', 'z', 'y'};
    public static final char[] bigSuffixes = new char[]{'k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'};

    public static String extractName(ResourceLocation resource) {
        return StringUtils.extractName(resource.toString());
    }

    public static String extractName(String filename) {
        int ix = Math.max(filename.lastIndexOf(47), Math.max(filename.lastIndexOf(92), filename.lastIndexOf(58))) + 1;
        if (filename.contains(".")) {
            return filename.substring(ix, filename.lastIndexOf(46)).trim();
        }
        return filename.substring(ix);
    }

    public static String formatNumberShort(double number) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(2);
        format.applyPattern("##0.##E0");
        String[] exploded = format.format(number).split("E");
        Object retval = exploded[0];
        if (((String)retval).length() > 3) {
            retval = ((String)retval).charAt(3) == '.' ? ((String)retval).substring(0, 3) : ((String)retval).substring(0, 4);
        }
        if (exploded.length > 1) {
            int exponent = Integer.parseInt(exploded[1]);
            if (exponent > 0) {
                int index = exponent / 3 - 1;
                retval = index > bigSuffixes.length - 1 ? "Infinite M" : (String)retval + bigSuffixes[index];
            } else if (exponent < 0) {
                int index = exponent / -3 - 1;
                retval = (String)retval + smallSuffixes[index];
            }
        }
        return retval;
    }

    public static String formatNumberPercent(double number) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(2);
        format.applyPattern("##0.##");
        return format.format(number * 100.0);
    }

    public static String formatNumberFromUnits(double number, String units) {
        if (units.equals("%")) {
            return StringUtils.formatNumberPercent(number) + "%";
        }
        return StringUtils.formatNumberShort(number) + units;
    }

    public static String prependFormatTag(String str, char format) {
        return "\u00a7" + format + str;
    }

    public static String appendResetTag(String str) {
        return str + "\u00a7r";
    }

    public static String wrapFormatTags(String str, char format) {
        return StringUtils.appendResetTag(StringUtils.prependFormatTag(str, format));
    }

    public static String wrapFormatTags(String str, FormatCodes code) {
        return StringUtils.wrapFormatTags(str, code.character);
    }

    public static String wrapMultipleFormatTags(String str, Object ... tags) {
        for (Object tag : tags) {
            if (tag instanceof Character) {
                str = StringUtils.prependFormatTag(str, ((Character)tag).charValue());
                continue;
            }
            if (!(tag instanceof FormatCodes)) continue;
            str = StringUtils.prependFormatTag(str, ((FormatCodes)((Object)tag)).character);
        }
        return StringUtils.appendResetTag(str);
    }

    public static List<Component> wrapStringToLength(String str, int length) {
        if (str == null) {
            str = "";
        }
        String[] stringArray = StringUtils.wordUtilsWrap(str, length);
        ArrayList<Component> retList = new ArrayList<Component>();
        for (String s : stringArray) {
            retList.add((Component)Component.m_237113_((String)s));
        }
        return retList;
    }

    static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static String[] wordUtilsWrap(String str, int wrapLength) {
        if (str == null) {
            return null;
        }
        String newLineStr = System.lineSeparator();
        String wrapOn = " ";
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        if (StringUtils.isBlank(wrapOn)) {
            wrapOn = " ";
        }
        Pattern patternToWrapOn = Pattern.compile(wrapOn);
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (offset < inputLineLength) {
            int spaceToWrapAt = -1;
            Matcher matcher = patternToWrapOn.matcher(str.substring(offset, Math.min((int)Math.min(Integer.MAX_VALUE, (long)(offset + wrapLength) + 1L), inputLineLength)));
            if (matcher.find()) {
                if (matcher.start() == 0) {
                    offset += matcher.end();
                    continue;
                }
                spaceToWrapAt = matcher.start() + offset;
            }
            if (inputLineLength - offset <= wrapLength) break;
            while (matcher.find()) {
                spaceToWrapAt = matcher.start() + offset;
            }
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            matcher = patternToWrapOn.matcher(str.substring(offset + wrapLength));
            if (matcher.find()) {
                spaceToWrapAt = matcher.start() + offset + wrapLength;
            }
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str, offset, str.length());
            offset = inputLineLength;
        }
        wrappedLine.append(str, offset, str.length());
        return wrappedLine.toString().split(System.lineSeparator());
    }

    public static List<Component> wrapComponentToLength(Component component, int length) {
        if (component == null) {
            component = Component.m_237119_().m_7220_(component);
        }
        return StringUtils.wrapStringToLength(component.getString(), length);
    }

    public static List<String> wrapComponentToLength(String str, double length) {
        ArrayList<String> strlist = new ArrayList<String>();
        String[] words = str.split(" ");
        if (words.length == 0) {
            return null;
        }
        Object currLine = words[0];
        for (int i = 1; i < words.length; ++i) {
            String approxLine = (String)currLine + " " + words[i];
            if ((double)Minecraft.m_91087_().f_91062_.m_92895_(approxLine) > length) {
                strlist.add((String)currLine);
                currLine = " " + words[i];
                continue;
            }
            currLine = approxLine;
        }
        strlist.add((String)currLine);
        return strlist;
    }

    public static void drawLeftAlignedText(GuiGraphics gfx, Component text, double x, double y, Color color) {
        StringUtils.drawText(gfx, text, x, y - StringUtils.getStringHeight() * 0.5, color);
    }

    public static void drawLeftAlignedText(GuiGraphics gfx, String s, double x, double y, Color color) {
        StringUtils.drawText(gfx, s, x, y - StringUtils.getStringHeight() * 0.5, color);
    }

    public static void drawRightAlignedText(GuiGraphics gfx, Component text, double x, double y, Color color) {
        StringUtils.drawText(gfx, text, x - StringUtils.getStringWidth((FormattedText)text), y - StringUtils.getStringHeight() * 0.5, color);
    }

    public static void drawRightAlignedText(GuiGraphics gfx, String s, double x, double y, Color color) {
        StringUtils.drawText(gfx, s, x - StringUtils.getStringWidth(s), y - StringUtils.getStringHeight() * 0.5, color);
    }

    public static void drawCenteredText(GuiGraphics gfx, Component component, double x, double y, Color color) {
        StringUtils.drawCenteredText(gfx, component, (float)x, (float)y, color);
    }

    public static void drawCenteredText(GuiGraphics gfx, Component component, float x, float y, Color color) {
        StringUtils.drawText(gfx, component, (double)(x - (float)(StringUtils.getFontRenderer().m_92852_((FormattedText)component) / 2)), (double)y - StringUtils.getStringHeight() * 0.5, color);
    }

    public static void drawCenteredText(GuiGraphics gfx, String s, double x, double y, Color color) {
        StringUtils.drawText(gfx, s, x - (double)(StringUtils.getFontRenderer().m_92895_(s) / 2), y - StringUtils.getStringHeight() * 0.5, color);
    }

    public static void drawCenteredText(GuiGraphics gfx, String s, float x, float y, Color color) {
        StringUtils.drawText(gfx, s, (double)(x - (float)(StringUtils.getFontRenderer().m_92895_(s) / 2)), (double)y - StringUtils.getStringHeight() * 0.5, color);
    }

    public static void drawText(GuiGraphics gfx, Component component, double x, double y, Color color) {
        gfx.drawString(StringUtils.getFontRenderer(), component.m_7532_(), (float)x, (float)y, color.getARGBInt(), false);
    }

    public static void drawText(GuiGraphics gfx, String s, double x, double y, Color color) {
        gfx.drawString(StringUtils.getFontRenderer(), s, (float)x, (float)y, color.getARGBInt(), false);
    }

    public static void drawShadowedStringCentered(GuiGraphics gfx, Component text, double x, double y, Color color) {
        StringUtils.drawShadowedString(gfx, text, x - StringUtils.getStringWidth((FormattedText)text) / 2.0, y - StringUtils.getStringHeight() * 0.5, color);
    }

    public static void drawShadowedStringCentered(GuiGraphics gfx, Component text, double x, double y) {
        StringUtils.drawShadowedString(gfx, text, x - StringUtils.getStringWidth((FormattedText)text) / 2.0, y - StringUtils.getStringHeight() * 0.5);
    }

    public static void drawShadowedStringCentered(GuiGraphics gfx, String s, double x, double y, Color color) {
        StringUtils.drawShadowedString(gfx, s, x - StringUtils.getStringWidth(s) / 2.0, y - StringUtils.getStringHeight() * 0.5, color);
    }

    public static void drawShadowedStringCentered(GuiGraphics gfx, String s, double x, double y) {
        StringUtils.drawShadowedString(gfx, s, x - StringUtils.getStringWidth(s) / 2.0, y - StringUtils.getStringHeight() * 0.5);
    }

    public static void drawRightAlignedShadowedString(GuiGraphics gfx, Component text, double x, double y) {
        StringUtils.drawShadowedString(gfx, text, x - StringUtils.getStringWidth((FormattedText)text), y - StringUtils.getStringHeight() * 0.5);
    }

    public static void drawRightAlignedShadowedString(GuiGraphics gfx, Component s, double x, double y, Color color) {
        StringUtils.drawShadowedString(gfx, s, x - StringUtils.getStringWidth((FormattedText)s), y - StringUtils.getStringHeight() * 0.5, color);
    }

    public static void drawRightAlignedShadowedString(GuiGraphics gfx, String s, double x, double y, Color color) {
        StringUtils.drawShadowedString(gfx, s, x - StringUtils.getStringWidth(s), y - StringUtils.getStringHeight() * 0.5, color);
    }

    public static void drawRightAlignedShadowedString(GuiGraphics gfx, String s, double x, double y) {
        StringUtils.drawShadowedString(gfx, s, x - StringUtils.getStringWidth(s), y);
    }

    public static void drawLeftAlignedShadowedString(GuiGraphics gfx, Component text, double x, double y) {
        StringUtils.drawShadowedString(gfx, text, x, y - StringUtils.getStringHeight() * 0.5);
    }

    public static void drawLeftAlignedShadowedString(GuiGraphics gfx, Component text, double x, double y, Color color) {
        StringUtils.drawShadowedString(gfx, text, x, y - StringUtils.getStringHeight() * 0.5, color);
    }

    public static void drawLeftAlignedShadowedString(GuiGraphics gfx, String s, double x, double y) {
        StringUtils.drawShadowedString(gfx, s, x, y - StringUtils.getStringHeight() * 0.5);
    }

    public static void drawLeftAlignedShadowedString(GuiGraphics gfx, String s, double x, double y, Color color) {
        StringUtils.drawShadowedString(gfx, s, x, y - StringUtils.getStringHeight() * 0.5, color);
    }

    public static void drawShadowedString(GuiGraphics gfx, Component s, double x, double y) {
        StringUtils.drawShadowedString(gfx, s, x, y, Color.WHITE);
    }

    public static void drawShadowedString(GuiGraphics gfx, String s, double x, double y) {
        StringUtils.drawShadowedString(gfx, s, x, y, Color.WHITE);
    }

    public static void drawShadowedString(GuiGraphics gfx, Component s, double x, double y, Color color) {
        gfx.m_280168_().m_85836_();
        gfx.m_280168_().m_252880_(0.0f, 0.0f, 32.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Lighting.m_84931_();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        gfx.drawString(StringUtils.getFontRenderer(), s.m_7532_(), (float)x, (float)y, color.getARGBInt(), true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        gfx.m_280168_().m_85849_();
    }

    public static void drawShadowedString(GuiGraphics gfx, String txt, double x, double y, Color color) {
        gfx.m_280168_().m_85836_();
        gfx.m_280168_().m_252880_(0.0f, 0.0f, 32.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Lighting.m_84931_();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        gfx.drawString(StringUtils.getFontRenderer(), txt, (float)x, (float)y, color.getARGBInt(), true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        gfx.m_280168_().m_85849_();
    }

    public static void drawShadowedStringsJustified(GuiGraphics gfx, List<String> words, double x1, double x2, double y) {
        int totalwidth = 0;
        for (String word : words) {
            totalwidth = (int)((double)totalwidth + StringUtils.getStringWidth(word));
        }
        double spacing = (x2 - x1 - (double)totalwidth) / (double)(words.size() - 1);
        double currentwidth = 0.0;
        for (String word : words) {
            StringUtils.drawShadowedString(gfx, word, x1 + currentwidth, y);
            currentwidth += StringUtils.getStringWidth(word) + spacing;
        }
    }

    public static Font getFontRenderer() {
        return Minecraft.m_91087_().f_91062_;
    }

    public static double getStringWidth(String s) {
        return StringUtils.getFontRenderer().m_92895_(s);
    }

    public static double getStringHeight() {
        Objects.requireNonNull(StringUtils.getFontRenderer());
        return 9.0;
    }

    public static double getStringWidth(FormattedText s) {
        return StringUtils.getFontRenderer().m_92852_(s);
    }

    public static double getStringWidth(FormattedCharSequence s) {
        return StringUtils.getFontRenderer().m_92724_(s);
    }

    public static enum FormatCodes {
        Black('0'),
        DarkBlue('1'),
        DarkGreen('2'),
        DarkAqua('3'),
        DarkRed('4'),
        Purple('5'),
        Gold('6'),
        Grey('7'),
        DarkGrey('8'),
        Indigo('9'),
        BrightGreen('a'),
        Aqua('b'),
        Red('c'),
        Pink('d'),
        Yellow('e'),
        White('f'),
        RandomChar('k'),
        Bold('l'),
        Strike('m'),
        Underlined('n'),
        Italic('o'),
        Reset('r');

        public final char character;

        private FormatCodes(char character) {
            this.character = character;
        }
    }
}

