/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.widgets.relic;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class AbilityCardWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget {
    private final RelicDescriptionScreen screen;
    private final String ability;
    private float scale = 1.0f;
    private float scaleOld = 1.0f;
    private int shakeDelta = 0;

    public AbilityCardWidget(int x, int y, RelicDescriptionScreen screen, String ability) {
        super(x, y, 32, 47);
        this.screen = screen;
        this.ability = ability;
    }

    @Override
    public void m_5691_() {
        IRelicItem relic;
        Item item = this.screen.getStack().m_41720_();
        if (item instanceof IRelicItem && (relic = (IRelicItem)item).canUseAbility(this.screen.stack, this.ability)) {
            this.MC.m_91152_((Screen)new AbilityDescriptionScreen((Player)this.MC.f_91074_, this.screen.container, this.screen.slot, this.screen.screen, this.ability));
        } else {
            this.shakeDelta = Math.min(20, this.shakeDelta + (this.shakeDelta > 0 ? 5 : 15));
            this.MC.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11794_, (float)1.0f));
        }
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Item item;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !((item = this.screen.stack.m_41720_()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        TextureManager manager = this.MC.m_91097_();
        PoseStack poseStack = guiGraphics.m_280168_();
        boolean canUse = relic.canUseAbility(this.screen.stack, this.ability);
        boolean canUpgrade = relic.mayPlayerUpgrade((Player)this.MC.f_91074_, this.screen.stack, this.ability);
        ResourceLocation card = new ResourceLocation("relics", "textures/gui/description/cards/" + ForgeRegistries.ITEMS.getKey((Object)this.screen.stack.m_41720_()).m_135815_() + "/" + (String)relic.getAbilityData(this.ability).getIcon().apply((Object)this.MC.f_91074_, (Object)this.screen.stack, (Object)this.ability) + ".png");
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        float partialTicks = this.MC.m_91296_();
        float lerpedScale = Mth.m_14179_((float)partialTicks, (float)this.scaleOld, (float)this.scale);
        poseStack.m_85841_(lerpedScale, lerpedScale, lerpedScale);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / lerpedScale, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / lerpedScale, 0.0f);
        float color = canUse ? (float)((double)1.05f + Math.sin((float)(player.f_19797_ + this.ability.length() * 10) * 0.2f) * (double)0.1f) : (canUpgrade ? 0.5f : 0.25f);
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
        guiGraphics.m_280163_(card, -11, -16, 0.0f, 0.0f, 22, 31, 22, 31);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280163_(canUse ? DescriptionTextures.SMALL_CARD_FRAME_ACTIVE : DescriptionTextures.SMALL_CARD_FRAME_INACTIVE, -(this.f_93618_ / 2), -(this.f_93619_ / 2) - 1, 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
        if (!canUse) {
            guiGraphics.m_280163_(DescriptionTextures.CHAINS, -(this.f_93618_ / 2), -(this.f_93619_ / 2) + 1, 0.0f, 0.0f, 32, 41, 32, 41);
            MutableComponent level = Component.m_237113_((String)String.valueOf(relic.getAbilityData(this.ability).getRequiredLevel())).m_130940_(ChatFormatting.BOLD);
            color = (float)this.shakeDelta * 0.04f;
            RenderSystem.setShaderColor((float)1.0f, (float)(1.0f - color), (float)(1.0f - color), (float)1.0f);
            poseStack.m_85836_();
            if (this.shakeDelta > 0) {
                poseStack.m_252781_(Axis.f_252403_.m_252961_((float)Math.sin(((float)player.f_19797_ + partialTick) * 0.75f) * 0.1f));
            }
            guiGraphics.m_280163_(DescriptionTextures.LOCK_INACTIVE, -(this.f_93618_ / 2) + 9, -(this.f_93619_ / 2) + 14, 0.0f, 0.0f, 14, 17, 14, 17);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            guiGraphics.m_280614_(this.MC.f_91062_, (Component)level, (-(this.f_93618_ / 2) + 16) * 2 - this.MC.f_91062_.m_92852_((FormattedText)level) / 2, (-(this.f_93619_ / 2) + 24) * 2, 12037849, true);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
        if (canUpgrade) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)DescriptionTextures.UPGRADE);
            manager.m_174784_(DescriptionTextures.UPGRADE);
            RenderSystem.enableBlend();
            RenderUtils.renderAnimatedTextureFromCenter(poseStack, 0.0f, -1.0f, 20.0f, 400.0f, 20.0f, 20.0f, 0.9f + (float)(Math.sin(((float)player.f_19797_ + partialTick) * 0.25f) * (double)0.025f), AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2).frame(12, 2).frame(13, 2).frame(14, 2).frame(15, 2).frame(16, 2).frame(17, 2).frame(18, 2).frame(19, 2));
            RenderSystem.disableBlend();
        }
        int xOff = 0;
        for (int i = 0; i < 5; ++i) {
            guiGraphics.m_280163_(DescriptionTextures.SMALL_STAR_HOLE, -(this.f_93618_ / 2) + xOff + 4, -(this.f_93619_ / 2) + 40, 0.0f, 0.0f, 4, 4, 4, 4);
            xOff += 5;
        }
        xOff = 0;
        int quality = relic.getAbilityQuality(this.screen.stack, this.ability);
        boolean isAliquot = quality % 2 == 1;
        int i = 0;
        while ((double)i < Math.floor((double)quality / 2.0)) {
            guiGraphics.m_280163_(canUse ? DescriptionTextures.SMALL_STAR_ACTIVE : DescriptionTextures.SMALL_STAR_INACTIVE, -(this.f_93618_ / 2) + xOff + 4, -(this.f_93619_ / 2) + 40, 0.0f, 0.0f, 4, 4, 4, 4);
            xOff += 5;
            ++i;
        }
        if (isAliquot) {
            guiGraphics.m_280163_(canUse ? DescriptionTextures.SMALL_STAR_ACTIVE : DescriptionTextures.SMALL_STAR_INACTIVE, -(this.f_93618_ / 2) + xOff + 4, -(this.f_93619_ / 2) + 40, 0.0f, 0.0f, 2, 4, 4, 4);
        }
        if (this.m_274382_()) {
            guiGraphics.m_280163_(DescriptionTextures.SMALL_CARD_FRAME_OUTLINE, -(this.f_93618_ / 2) - 1, -(this.f_93619_ / 2) - 2, 0.0f, 0.0f, this.f_93618_ + 2, this.f_93619_ + 3, this.f_93618_ + 2, this.f_93619_ + 3);
        }
        MutableComponent title = Component.m_237113_((String)(canUse ? String.valueOf(relic.getAbilityPoints(this.screen.stack, this.ability)) : "?")).m_130940_(ChatFormatting.BOLD);
        float textScale = 0.5f;
        poseStack.m_85841_(textScale, textScale, textScale);
        guiGraphics.m_280614_(this.MC.f_91062_, (Component)title, -((this.f_93618_ + 1) / 2) - this.MC.f_91062_.m_92852_((FormattedText)title) / 2 + 16, -(this.f_93619_ / 2) - 19, canUse ? 16769656 : 12037849, true);
        poseStack.m_85849_();
    }

    @Override
    public void onTick() {
        Item item = this.screen.stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        float maxScale = 1.1f;
        float minScale = 1.0f;
        RandomSource random = this.MC.f_91074_.m_217043_();
        if (relic.mayPlayerUpgrade((Player)this.MC.f_91074_, this.screen.stack, this.ability) && this.MC.f_91074_.f_19797_ % 7 == 0) {
            ParticleStorage.addParticle(this.screen, new ExperienceParticleData(new Color(200 + random.m_188503_(50), 150 + random.m_188503_(100), 0), this.m_252754_() + 5 + random.m_188503_(18), this.m_252907_() + 18, 1.0f + random.m_188501_() * 0.5f, 100 + random.m_188503_(50)));
        }
        this.scaleOld = this.scale;
        if (this.m_274382_()) {
            if (this.MC.f_91074_.f_19797_ % 3 == 0) {
                ParticleStorage.addParticle(this.screen, new ExperienceParticleData(relic.canUseAbility(this.screen.stack, this.ability) ? new Color(200 + random.m_188503_(50), 150 + random.m_188503_(100), 0) : new Color(100 + random.m_188503_(100), 100 + random.m_188503_(100), 100 + random.m_188503_(100)), this.m_252754_() + random.m_188503_(this.f_93618_), this.m_252907_() - 1, 1.0f + random.m_188501_() * 0.5f, 100 + random.m_188503_(50)));
            }
            if (this.scale < maxScale) {
                this.scale = Math.min(maxScale, this.scale + 0.04f);
            }
        } else if (this.scale > minScale) {
            this.scale = Math.max(minScale, this.scale - 0.03f);
        }
        if (this.shakeDelta > 0) {
            --this.shakeDelta;
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int requiredLevel;
        Item item = this.screen.stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        AbilityData data = relic.getAbilityData(this.ability);
        if (data == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 110;
        int renderWidth = 0;
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237115_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)this.screen.stack.m_41720_()).m_135815_() + ".ability." + this.ability)).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.UNDERLINE)});
        int level = relic.getLevel(this.screen.stack);
        if (level < (requiredLevel = data.getRequiredLevel())) {
            entries.add(Component.m_237113_((String)" "));
            entries.add(Component.m_237113_((String)"").m_7220_((Component)Component.m_237110_((String)"tooltip.relics.researching.relic.card.low_level", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(requiredLevel)).m_130940_(ChatFormatting.BOLD)})));
        } else if (data.getMaxLevel() == 0) {
            entries.add(Component.m_237113_((String)" "));
            entries.add(Component.m_237113_((String)"").m_7220_((Component)Component.m_237115_((String)"tooltip.relics.researching.relic.card.no_stats")));
        } else if (relic.mayPlayerUpgrade((Player)this.MC.f_91074_, this.screen.stack, this.ability)) {
            entries.add(Component.m_237113_((String)" "));
            entries.add(Component.m_237113_((String)"").m_7220_((Component)Component.m_237115_((String)"tooltip.relics.researching.relic.card.ready_to_upgrade")));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.MC.f_91062_.m_92852_((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 2, maxWidth);
            }
            tooltip.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, maxWidth * 2));
        }
        int height = tooltip.size() * 5;
        int y = this.m_93694_() / 2;
        float partialTicks = this.MC.m_91296_();
        float lerpedScale = Mth.m_14179_((float)partialTicks, (float)this.scaleOld, (float)this.scale);
        poseStack.m_85841_(lerpedScale, lerpedScale, lerpedScale);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.m_5711_() / 2.0f) / lerpedScale, ((float)this.m_252907_() + (float)this.m_93694_() / 2.0f) / lerpedScale, 0.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, height, -((renderWidth + 19) / 2), y);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            guiGraphics.m_280649_(this.MC.f_91062_, entry, -(this.MC.f_91062_.m_92724_(entry) / 2), (y + yOff + 9) * 2, 6696723, false);
            yOff += 5;
            poseStack.m_85849_();
        }
    }

    @Override
    public void m_7435_(SoundManager handler) {
        IRelicItem relic;
        Item item = this.screen.getStack().m_41720_();
        if (item instanceof IRelicItem && (relic = (IRelicItem)item).canUseAbility(this.screen.stack, this.ability)) {
            super.m_7435_(handler);
        }
    }
}

