/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.jmdefaultconfig;

import java.io.File;
import java.io.IOException;
import me.frankv.jmi.JMI;
import me.frankv.jmi.jmdefaultconfig.Version;
import me.frankv.jmi.util.FileManager;
import org.apache.commons.io.FileUtils;

public class JMDefaultConfig {
    private Version existVersion;
    private final FileManager<Version> fileManager = new FileManager<Version>("/journeymap/defaultconfig.json", Version.class);

    public JMDefaultConfig() {
        if (!this.fileManager.getFile().exists()) {
            this.fileManager.write(new Version(-1));
        }
        this.existVersion = this.fileManager.read();
    }

    public void tryWriteJMDefaultConfig() {
        Integer version = JMI.clientConfig.getDefaultConfigVersion();
        if (version >= 0 && this.existVersion.version < version) {
            this.writeJMDefaultConfig(version);
        }
    }

    private void writeJMDefaultConfig(int newVersion) {
        File source = new File(System.getProperty("user.dir") + "/config/jmdefaultconfig");
        File dest = new File(System.getProperty("user.dir") + "/journeymap/");
        if (!source.exists() || !source.isDirectory()) {
            JMI.LOGGER.warn("No default config found.");
            return;
        }
        JMI.LOGGER.info("Writing default configs for Journeymap...");
        try {
            this.fileManager.write(new Version(newVersion));
            FileUtils.copyDirectory((File)source, (File)dest);
            JMI.LOGGER.info("Journeymap configs updated.");
        }
        catch (IOException e) {
            JMI.LOGGER.error("Failed to write default configs " + e);
        }
    }
}

