/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.animatica.util;

import java.util.Iterator;

class MergedIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator1;
    private final Iterator<T> iterator2;
    private boolean useIterator1;

    public MergedIterator(Iterator<T> iterator1, Iterator<T> iterator2) {
        this.iterator1 = iterator1;
        this.iterator2 = iterator2;
        this.useIterator1 = true;
    }

    @Override
    public boolean hasNext() {
        return this.useIterator1 && this.iterator1.hasNext() || this.iterator2.hasNext();
    }

    @Override
    public T next() {
        if (this.useIterator1) {
            if (this.iterator1.hasNext()) {
                return this.iterator1.next();
            }
            this.useIterator1 = false;
        }
        return this.iterator2.next();
    }
}

