/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.ITiledBlock;
import com.endertech.minecraft.forge.data.ForgeEnergy;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.tiles.ChameleonBlockTile;
import com.endertech.minecraft.forge.units.ITickableUnit;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import com.endertech.minecraft.mods.adchimneys.blocks.Pipe;
import com.endertech.minecraft.mods.adchimneys.blocks.Vent;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class Pump
extends Container
implements ITiledBlock<Tile> {
    public static ForgeConfigSpec.ConfigValue<Boolean> invertedRedstoneSignal;
    public static ForgeConfigSpec.ConfigValue<Boolean> energyStorageEnabled;
    public static ForgeConfigSpec.ConfigValue<Integer> energyStorageCapacity;
    public static ForgeConfigSpec.ConfigValue<Integer> energyStorageConsumption;
    protected static final VoxelShape HOLES_TOP;
    protected static final VoxelShape SUPPORTS_VERT;
    protected static final VoxelShape SHAPE;
    protected static final VoxelShape SUPPORT_SHAPE;

    public Pump(Container.Properties<?> props) {
        super(props);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61443_});
    }

    public Tile createTile(BlockPos pos, BlockState state) {
        return new Tile(pos, state);
    }

    public Class<Tile> getTileClass() {
        return Tile.class;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isActive(BlockGetter level, BlockPos pos) {
        return (Boolean)level.m_8055_(pos).m_61143_((Property)BlockStateProperties.f_61443_);
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        return level.m_7469_() * 2 / 3;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    public boolean updateLitState(ServerLevel level, BlockPos pos, BlockState state, boolean lit) {
        if ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != lit) {
            return level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(lit)));
        }
        return false;
    }

    public List<BlockPos> getClosestActiveExhaustPumps(LevelAccessor level, BlockPos pos) {
        return this.getTile((BlockGetter)level, pos).map(tile -> tile.getClosestActiveExhaustPumps(level, pos)).orElse(Collections.emptyList());
    }

    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.PUMP;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.isActive((BlockGetter)level, pos)) {
            this.spawnActiveStateParticles(level, pos);
        }
    }

    protected void spawnActiveStateParticles(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.m_121945_(direction);
            if (level.m_8055_(blockpos).m_60804_((BlockGetter)level, blockpos)) continue;
            Function<Direction.Axis, Double> delta = axis -> direction.m_122434_() == axis ? 0.5 + 0.5625 * (double)direction.m_122436_().m_123304_(axis) : level.m_213780_().m_188500_();
            level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + delta.apply(Direction.Axis.X), (double)pos.m_123342_() + delta.apply(Direction.Axis.Y), (double)pos.m_123343_() + delta.apply(Direction.Axis.Z), 0.0, 0.0, 0.0);
        }
    }

    static {
        HOLES_TOP = Shapes.m_83124_((VoxelShape)Pump.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Pump.m_49796_((double)3.0, (double)13.0, (double)10.0, (double)13.0, (double)16.0, (double)13.0), Pump.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)6.0, (double)16.0, (double)13.0), Pump.m_49796_((double)10.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)});
        SUPPORTS_VERT = Shapes.m_83124_((VoxelShape)Pump.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (VoxelShape[])new VoxelShape[0]);
        VoxelShape hopper = Shapes.m_83124_((VoxelShape)Pump.m_49796_((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Pump.m_49796_((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Pump.m_49796_((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0)});
        VoxelShape shape = Shapes.m_83148_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)Vent.HOLE_CENTER, (VoxelShape[])new VoxelShape[]{Vent.HOLES_X, Vent.HOLES_Z, Vent.HOLES_BOTTOM, HOLES_TOP}), (BooleanOp)BooleanOp.f_82685_);
        SHAPE = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Pipe.SHAPE);
        SUPPORT_SHAPE = Shapes.m_83124_((VoxelShape)SHAPE, (VoxelShape[])new VoxelShape[]{Vent.SUPPORTS_SIDE, SUPPORTS_VERT});
    }

    public static class Tile
    extends ChameleonBlockTile
    implements ITickableUnit {
        private final GameTime updateInterval = GameTime.second();
        private final HopperAnimation hopperAnimation = new HopperAnimation();
        protected final ForgeEnergy.Storage energyStorage;
        protected final LazyOptional<ForgeEnergy.Storage> energyStorageHolder;
        protected List<BlockPos> closestActiveExhaustPumps = null;
        protected boolean active = false;

        public Tile(BlockPos pos, BlockState state) {
            super((BlockEntityType)AdChimneys.getInstance().tiles.pump.get(), pos, state);
            ForgeEnergy.StorageProps props = ForgeEnergy.StorageProps.create((boolean)((Boolean)energyStorageEnabled.get()), (int)((Integer)energyStorageCapacity.get()), (int)((Integer)energyStorageConsumption.get()));
            this.energyStorage = ForgeEnergy.Storage.with((ForgeEnergy.StorageProps)props);
            this.energyStorageHolder = LazyOptional.of(() -> this.energyStorage);
        }

        protected Optional<BlockPos> getHopperInput() {
            BlockPos pos;
            Level level = this.getWorldLevel();
            if (level != null && (pos = (BlockPos)GameWorld.SmokeContainers.getConnectedHopper((LevelReader)level, (BlockPos)this.m_58899_()).orElse(null)) != null) {
                if (GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)(pos = pos.m_7494_()))) {
                    pos = GameWorld.SmokeContainers.getTopmostChimney((LevelReader)level, (BlockPos)pos).m_7494_();
                }
                return Optional.of(pos);
            }
            return Optional.empty();
        }

        @Nullable
        public Level getWorldLevel() {
            return this.m_58904_();
        }

        protected boolean updateActiveState() {
            Level level = this.getWorldLevel();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                BlockPos pos = this.m_58899_();
                boolean powered = level2.m_276867_(pos);
                if (((Boolean)invertedRedstoneSignal.get()).booleanValue()) {
                    boolean bl = powered = !powered;
                }
                if (this.energyStorage.isEnabled() && !this.energyStorage.hasEnoughEnergy()) {
                    powered = false;
                }
                if (powered != this.active) {
                    this.active = powered;
                    BlockState state = level2.m_8055_(pos);
                    Block block = state.m_60734_();
                    if (block instanceof Pump) {
                        Pump pump = (Pump)block;
                        pump.updateLitState(level2, pos, state, this.active);
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean exists() {
            return !this.m_58901_();
        }

        public GameTime getUpdateInterval() {
            return this.updateInterval;
        }

        public void tick() {
            if (Optional.ofNullable(this.getWorldLevel()).filter(Level::m_5776_).isPresent()) {
                this.getHopperAnimation().tick();
            }
            super.tick();
        }

        public void onUpdate() {
            Level level = this.getWorldLevel();
            if (level == null) {
                return;
            }
            if (level.m_5776_()) {
                this.getHopperAnimation().updateState(this.isActive(), GameWorld.SmokeContainers.isReversedPump((LevelReader)level, (BlockPos)this.m_58899_()));
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                boolean needSync = this.updateActiveState();
                if (this.isActive()) {
                    Optional<BlockPos> inputPos;
                    if (this.energyStorage.consumeEnergy() > 0) {
                        needSync = true;
                    }
                    if (this.getUpdateInterval().mult(2).pastIn((Level)serverLevel)) {
                        this.closestActiveExhaustPumps = null;
                        this.getClosestActiveExhaustPumps((LevelAccessor)serverLevel, this.m_58899_());
                    }
                    if ((inputPos = this.getHopperInput()).isPresent()) {
                        BlockPos pos = inputPos.get();
                        if (GameWorld.SmokeContainers.isVent((LevelReader)serverLevel, (BlockPos)pos)) {
                            WorldSearch.VentPipe.suck((LevelAccessor)serverLevel, (BlockPos)pos, (BlockPos)this.m_58899_());
                        } else if (this.getUpdateInterval().mult(3).pastIn((Level)serverLevel)) {
                            this.suckPollutionViaHopper(pos);
                        }
                    } else {
                        WorldSearch.VentPipe.suck((LevelAccessor)serverLevel, (BlockPos)this.m_58899_());
                    }
                }
                if (needSync) {
                    this.syncWithClients();
                }
            }
        }

        public HopperAnimation getHopperAnimation() {
            return this.hopperAnimation;
        }

        protected List<BlockPos> getClosestActiveExhaustPumps(LevelAccessor level, BlockPos pos) {
            if (this.closestActiveExhaustPumps == null) {
                List pumps = GameWorld.SmokeContainers.getClosestActiveExhaustPumps((LevelAccessor)level, (BlockPos)pos);
                this.closestActiveExhaustPumps = Collections.unmodifiableList(pumps);
            }
            return this.closestActiveExhaustPumps;
        }

        protected void suckPollutionViaHopper(BlockPos inputPos) {
            Level level = this.getWorldLevel();
            if (level == null || level.m_5776_()) {
                return;
            }
            if (level.m_8055_(inputPos).m_60783_((BlockGetter)level, inputPos, Direction.DOWN)) {
                return;
            }
            IntBounds height = IntBounds.between((Integer)inputPos.m_123342_(), (Integer)(inputPos.m_123342_() + 2));
            int maxRadius = GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)inputPos.m_7495_()) ? 1 : GameWorld.SmokeContainers.getHopperSuctionRange((LevelReader)level, (BlockPos)inputPos.m_7495_());
            final BlockPos pumpPos = this.m_58899_();
            WorldSearch.VertCylinder searcher = new WorldSearch.VertCylinder((LevelAccessor)level, inputPos, height, maxRadius){

                protected boolean isValidPath(BlockPos pos) {
                    if (this.level.m_46859_(pos)) {
                        return true;
                    }
                    if (this.lastUsedDirection == null) {
                        return true;
                    }
                    BlockPos last = pos.m_121945_(this.lastUsedDirection.m_122424_());
                    return !this.level.m_8055_(last).m_60783_((BlockGetter)this.level, last, this.lastUsedDirection) && !this.level.m_8055_(pos).m_60783_((BlockGetter)this.level, pos, this.lastUsedDirection.m_122424_());
                }

                protected boolean isValidBlock(BlockPos pos) {
                    return this.level.m_8055_(pos).m_60734_() instanceof IPollutant;
                }

                protected boolean onValidFound(BlockPos pos) {
                    Block block = this.level.m_8055_(pos).m_60734_();
                    if (block instanceof IPollutant) {
                        IPollutant pollutant = (IPollutant)block;
                        int count = GameWorld.SmokeContainers.pumpPollutionThrough(List.of(pumpPos), (LevelAccessor)this.level, (IPollutant)pollutant, (int)1);
                        if (count > 0) {
                            pollutant.spend(this.level, pos, count);
                        }
                    }
                    return false;
                }
            };
            searcher.build();
        }

        public void m_7651_() {
            super.m_7651_();
            this.energyStorageHolder.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap == ForgeCapabilities.ENERGY && this.energyStorage.isEnabled()) {
                return this.energyStorageHolder.cast();
            }
            return super.getCapability(cap, side);
        }

        public void readSharedData(CompoundTag compound) {
            super.readSharedData(compound);
            this.active = compound.m_128471_("active");
            this.energyStorage.readFrom(compound);
        }

        public CompoundTag writeSharedData(CompoundTag compound) {
            super.writeSharedData(compound);
            compound.m_128379_("active", this.active);
            this.energyStorage.writeTo(compound);
            return compound;
        }
    }

    public static class HopperAnimation {
        public final FloatBounds valueRange = FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0f));
        public final FloatBounds speedRange = FloatBounds.between((Float)Float.valueOf(0.01f), (Float)Float.valueOf(0.3f));
        public final IntBounds pauseRange = IntBounds.between((Integer)5, (Integer)50);
        protected boolean enabled = false;
        protected boolean reversed = false;
        protected float value = this.valueRange.getMax().floatValue();
        protected float speed = this.speedRange.getMin().floatValue();
        protected int pause = this.pauseRange.getMin();

        public void updateState(boolean enabled, boolean reversed) {
            this.enabled = enabled;
            this.reversed = reversed;
            this.updateSpeed();
        }

        public float getValue(float partialTicks) {
            return this.enabled && this.pause == 0 ? this.valueRange.enclose(Float.valueOf(this.value + this.speed * partialTicks)).floatValue() : this.value;
        }

        protected void updateSpeed() {
            if (this.speed > 0.0f) {
                this.speed = (this.reversed ? this.speedRange.getMin() : this.speedRange.getMax()).floatValue();
            }
            if (this.speed < 0.0f) {
                this.speed = this.reversed ? -this.speedRange.getMax().floatValue() : -this.speedRange.getMin().floatValue();
            }
        }

        public void tick() {
            if (!this.enabled) {
                return;
            }
            if (this.pause > 0) {
                --this.pause;
                return;
            }
            this.value += this.speed;
            if (!this.valueRange.encloses(Float.valueOf(this.value))) {
                this.speed = -this.speed;
                this.updateSpeed();
                if (this.speed > 0.0f) {
                    this.pause = this.reversed ? this.pauseRange.randomBetween() : this.pauseRange.getMin();
                }
                if (this.speed < 0.0f) {
                    this.pause = this.reversed ? this.pauseRange.getMin() : this.pauseRange.randomBetween();
                }
                this.value = this.valueRange.enclose(Float.valueOf(this.value)).floatValue();
            }
        }
    }

    public static class Properties<T extends Properties<T>>
    extends Container.Properties<T> {
        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
        }

        public static Properties<?> of(String name) {
            return new Properties<Properties>(Properties.class, name);
        }

        public T litStateEmission(int lightLevel) {
            this.vanillaProps.m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightLevel : 0);
            return (T)((Object)((Properties)this.self));
        }
    }
}

