/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.client;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.mods.adchimneys.blocks.Pump;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class PumpRenderer
implements BlockEntityRenderer<Pump.Tile> {
    protected final Lazy<ItemStack> vanillaCogwheel = Lazy.of(() -> new ItemStack((ItemLike)Items.f_42039_));
    protected final Lazy<ItemStack> createCogwheel = Lazy.of(() -> new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("create", "cogwheel"))));

    public PumpRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(Pump.Tile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = tile.m_58904_();
        RenderType renderType = RenderType.m_110457_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
        BlockPos pos = tile.m_58899_();
        float progress = tile.getHopperAnimation().getValue(partialTicks);
        if (level != null) {
            this.renderHopper(level, pos, progress, poseStack, vertexConsumer);
            this.renderCogwheel(level, pos, progress, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    protected void renderHopper(Level level, BlockPos pos, float progress, PoseStack poseStack, VertexConsumer vertexConsumer) {
        float offset = 0.1875f;
        float scale = 0.625f;
        float scaleY = FloatBounds.between((Float)Float.valueOf(0.5f), (Float)Float.valueOf(0.875f)).interpolateUp(progress).floatValue();
        poseStack.m_85836_();
        poseStack.m_252880_(offset, 0.01f, offset);
        poseStack.m_85841_(scale, scaleY, scale);
        this.renderBlock(level, Blocks.f_50332_.m_49966_(), pos, poseStack, vertexConsumer);
        poseStack.m_85849_();
    }

    protected void renderCogwheel(Level level, BlockPos pos, float progress, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float offset = 0.25f;
        float dy = 0.001f;
        float scale = 1.0f;
        float rotationY = FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(360.0f)).interpolateUp(progress).floatValue();
        boolean vanilla = ((ItemStack)this.createCogwheel.get()).m_41619_();
        ItemStack cogwheelItem = vanilla ? (ItemStack)this.vanillaCogwheel.get() : (ItemStack)this.createCogwheel.get();
        for (int i = 0; i < (vanilla ? 3 : 1); ++i) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, offset + dy * (float)(i + 1), 0.5f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotationY + 120.0f * (float)i));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_85841_(scale, scale, scale);
            this.renderItem(level, cogwheelItem, poseStack, bufferSource, packedLight, packedOverlay);
            poseStack.m_85849_();
        }
    }

    protected void renderBlock(Level level, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer vertexConsumer) {
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        dispatcher.m_110937_().m_234379_((BlockAndTintGetter)level, dispatcher.m_110910_(state), state, pos, poseStack, vertexConsumer, false, RandomSource.m_216327_(), state.m_60726_(pos), OverlayTexture.f_118083_);
    }

    protected void renderItem(Level level, ItemStack itemStack, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Minecraft.m_91087_().m_91291_().m_269128_(itemStack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, level, 0);
    }
}

