/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.compat;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public class Create {

    public static class LowHeated {
        static Emitter.Properties<?> basicBurner() {
            String id = "createlowheated:basic_burner:*";
            return ((Emitter.Properties)((Emitter.Properties)Emitter.Properties.tile("BurnTimeRemaining").id(id)).relatedBlocks(new String[]{id})).maxGapLength(2);
        }

        public static Emitter.Properties<?> litBurner() {
            return ((Emitter.Properties)LowHeated.basicBurner().metadata("[empowered=false]")).smoke(1, 0.5f);
        }

        public static Emitter.Properties<?> empoweredBurner() {
            return ((Emitter.Properties)LowHeated.basicBurner().metadata("[empowered=true]")).smoke(4, 2.0f);
        }
    }

    public static class DieselGenerators {
        public static Emitter.Properties<?> burner() {
            return ((Emitter.Properties)((Object)Emitter.Properties.with().customFactory(Burner::new))).smoke(1, 0.1f);
        }

        public static Emitter.Properties<?> engine() {
            return ((Emitter.Properties)((Object)Emitter.Properties.with().customFactory(Engine::new))).smoke(1, 1.0f, 2.0f);
        }

        public static class Engine
        extends Emitter {
            protected final Smoke silencedSmoke;
            protected final Smoke turbochargedSmoke;
            protected Upgrade upgrade = Upgrade.NONE;

            public Engine(@Nullable UnitConfig config, Emitter.Properties<?> props) {
                super(config, (Emitter.Properties)props.activeTag("#hardcoded_speed_check"));
                float amount = props.smoke.getAmount();
                float intensity = props.smoke.getIntensity();
                this.silencedSmoke = props.smoke.withIntensity(intensity * 0.1f);
                this.turbochargedSmoke = props.smoke.withAmount(amount * 2.0f).withIntensity(intensity * 1.5f);
            }

            @Override
            public Smoke getSmoke() {
                return switch (this.upgrade) {
                    default -> throw new IncompatibleClassChangeError();
                    case Upgrade.NONE -> super.getSmoke();
                    case Upgrade.SILENCER -> this.silencedSmoke;
                    case Upgrade.TURBOCHARGER -> this.turbochargedSmoke;
                };
            }

            public boolean isActive(@Nullable INBTSerializable<CompoundTag> nbtSource) {
                this.upgrade = Upgrade.NONE;
                if (nbtSource == null) {
                    return false;
                }
                try {
                    CompoundTag compound = TagHelper.serialize(nbtSource);
                    String upgrade = compound.m_128461_("Upgrade");
                    if (upgrade.contains("silencer")) {
                        this.upgrade = Upgrade.SILENCER;
                    } else if (upgrade.contains("turbocharger")) {
                        this.upgrade = Upgrade.TURBOCHARGER;
                    }
                    float speed = compound.m_128457_("Speed");
                    return speed != 0.0f;
                }
                catch (Exception e) {
                    return false;
                }
            }

            public static enum Upgrade {
                NONE,
                SILENCER,
                TURBOCHARGER;

            }
        }

        public static class Burner
        extends Emitter {
            public Burner(@Nullable UnitConfig config, Emitter.Properties<?> props) {
                super(config, (Emitter.Properties)props.activeTag("#hardcoded_heat_check"));
            }

            public boolean isActive(@Nullable INBTSerializable<CompoundTag> nbtSource) {
                if (nbtSource == null) {
                    return false;
                }
                try {
                    CompoundTag compound = TagHelper.serialize(nbtSource);
                    float heat = compound.m_128457_("Heat");
                    return heat > 0.0f;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
    }
}

