/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.particles;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.mods.adchimneys.network.SmokePoisonEffectMsg;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AbstractSmokeParticle {

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Instance
    extends TextureSheetParticle {
        protected static final int MAX_HIT_AFTER_HIT_AMOUNT = 2;
        protected static final double ON_HIT_MOTION_REDICTION = 0.3;
        protected static final double MIN_BOUNCE_MOTION = 0.1;
        protected boolean insideChimney = true;
        protected float chimneySize = 0.0f;
        protected int ticksInChimney = 0;
        protected int ignoreWindDelay = 0;
        protected long lastUpdateTime;
        protected final IWind wind;
        protected final SpriteSet animatedSprite;
        protected final BlockPos startPos;
        protected final GameTime poisonEffectUpdateInterval = GameTime.second();
        private int hitAfterHitCount = 0;

        public Instance(ClientLevel level, IWind wind, Smoke smoke, Vect3d pos, Vect3d motion, float scale, SpriteSet sprite) {
            super(level, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
            this.animatedSprite = sprite;
            this.wind = wind;
            this.m_108339_(sprite);
            this.f_107219_ = (Boolean)Smoke.canCollide.get();
            this.lastUpdateTime = level.m_46467_();
            this.startPos = this.getBlockPos();
            WorldData.getData((LevelAccessor)level).getSmokeLocations().countSmokeParticle(this);
        }

        public abstract void updateAnimatedSprite();

        public Vect3d getPosition() {
            return Vect3d.from((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        }

        public Vect3d getMotion() {
            return Vect3d.from((double)this.f_107215_, (double)this.f_107216_, (double)this.f_107217_);
        }

        public void setMotion(Vect3d motion) {
            this.f_107215_ = motion.x;
            this.f_107216_ = motion.y;
            this.f_107217_ = motion.z;
        }

        public void setColor(ColorARGB color) {
            this.m_107253_(color.getRed().toFloat(), color.getGreen().toFloat(), color.getBlue().toFloat());
        }

        public void setPosition(Vect3d pos) {
            this.m_107264_(pos.x, pos.y, pos.z);
        }

        public BlockPos getBlockPos() {
            return BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        }

        protected void tryColorizeWith(ColorARGB color) {
            if (Smoke.colorize == null || !((Boolean)Smoke.colorize.get()).booleanValue()) {
                return;
            }
            float alpha = color.getAlpha().toFloat();
            if (CommonMath.Random.result((float)(alpha * ((Double)Smoke.coloringFactor.get()).floatValue()))) {
                this.setColor(color);
            }
        }

        public boolean m_107276_() {
            return super.m_107276_() && Mth.m_14154_((float)(this.f_107208_.m_46467_() - this.lastUpdateTime)) <= (float)this.f_107225_;
        }

        public void m_5989_() {
            this.lastUpdateTime = this.f_107208_.m_46467_();
            ++this.f_107224_;
            if (this.f_107224_ >= this.f_107225_) {
                this.m_107274_();
            }
            BlockPos blockPos = this.getBlockPos();
            BlockState state = this.f_107208_.m_8055_(blockPos);
            if (GameWorld.SmokeContainers.isChimney((LevelReader)this.f_107208_, (BlockPos)blockPos)) {
                VoxelShape shape = state.m_60812_((BlockGetter)this.f_107208_, blockPos);
                if (!shape.m_83281_()) {
                    AABB bb = shape.m_83215_();
                    this.insideChimney = bb.m_82338_(blockPos).m_82393_(this.f_107212_, this.f_107213_, this.f_107214_);
                    this.chimneySize = (float)Math.min(bb.m_82362_(), bb.m_82385_());
                } else {
                    this.insideChimney = false;
                    this.chimneySize = 1.0f;
                }
            } else {
                this.insideChimney = false;
            }
            if (this.insideChimney && CommonMath.notZero((double)this.f_107216_) && this.f_107216_ > 0.0) {
                ++this.ticksInChimney;
                --this.f_107224_;
            }
            this.f_107209_ = this.f_107212_;
            this.f_107210_ = this.f_107213_;
            this.f_107211_ = this.f_107214_;
            this.updateAnimatedSprite();
            this.updatePoisonEffect();
            if (this.ignoreWindDelay > 0) {
                --this.ignoreWindDelay;
            }
            boolean affectedByWind = false;
            if (!this.insideChimney && this.ignoreWindDelay <= 0) {
                for (Direction direction : GameWorld.Directions.CLOCKWISE_HORIZONTALS) {
                    BlockPos pos = blockPos.m_121945_(direction);
                    if (state.m_60783_((BlockGetter)this.f_107208_, blockPos, direction) || !this.f_107208_.m_46805_(pos) || !this.hasNoBlocksAbove(pos)) continue;
                    affectedByWind = true;
                    break;
                }
            }
            if (this.f_107216_ < 0.01 && this.ignoreWindDelay <= 0 && this.hasNoBlocksAbove(blockPos)) {
                this.f_107216_ = 0.1;
            }
            if (!this.insideChimney) {
                this.f_107216_ -= (double)this.f_107226_;
            }
            if (affectedByWind) {
                this.f_107215_ = this.wind.getMotion().x;
                this.f_107217_ = this.wind.getMotion().z;
            } else if (!this.insideChimney) {
                this.f_107215_ *= (double)this.f_172258_;
                this.f_107216_ *= (double)this.f_172258_;
                this.f_107217_ *= (double)this.f_172258_;
            }
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        }

        public boolean hasNoBlocksAbove(BlockPos pos) {
            return this.f_107208_.m_45527_(pos) && this.f_107208_.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() <= pos.m_123342_();
        }

        public void m_6257_(double dx, double dy, double dz) {
            this.move(Vect3d.from((double)dx, (double)dy, (double)dz));
        }

        public void move(Vect3d motion) {
            Vect3d nextPos = this.getPosition().add(motion);
            this.moveTo(nextPos);
        }

        private void moveTo(Vect3d nextPos) {
            if (this.f_107219_) {
                if (this.hitAfterHitCount > 2) {
                    this.m_107274_();
                    return;
                }
                Vect3d curPos = this.getPosition();
                BlockPos blockPos = nextPos.toBlockPos();
                if (!blockPos.equals((Object)this.getBlockPos()) && !GameWorld.isBlockLoaded((LevelReader)this.f_107208_, (BlockPos)blockPos)) {
                    this.m_107274_();
                    return;
                }
                BlockState blockState = this.f_107208_.m_8055_(blockPos);
                BlockHitResult hit = blockState.m_60812_((BlockGetter)this.f_107208_, blockPos).m_83220_(curPos.toVector3d(), nextPos.toVector3d(), blockPos);
                if (this.startPos.equals((Object)this.getBlockPos())) {
                    hit = null;
                }
                if (hit != null && !blockState.m_60783_((BlockGetter)this.f_107208_, blockPos, hit.m_82434_())) {
                    hit = null;
                }
                if (hit != null && hit.m_82434_().equals((Object)Direction.DOWN) && GameWorld.SmokeContainers.isChimney((LevelReader)this.f_107208_, (BlockPos)blockPos)) {
                    hit = null;
                }
                if (hit != null && hit.m_6662_() != HitResult.Type.MISS) {
                    ++this.hitAfterHitCount;
                    this.ignoreWindDelay = IntBounds.between((Integer)5, (Integer)15).randomBetween();
                    Direction.Axis axis = hit.m_82434_().m_122434_();
                    Vect3d hitLocation = Vect3d.from((Vec3)hit.m_82450_());
                    Vect3d bounceVec = nextPos.subtract(hitLocation);
                    double reduction = 0.3;
                    switch (axis) {
                        case X: {
                            bounceVec = bounceVec.invertX();
                            this.f_107215_ = -this.f_107215_ * reduction;
                            break;
                        }
                        case Z: {
                            bounceVec = bounceVec.invertZ();
                            this.f_107217_ = -this.f_107217_ * reduction;
                            break;
                        }
                        case Y: {
                            bounceVec = bounceVec.invertY();
                            if (CommonMath.isAlmostZero((double)(this.f_107215_ * this.f_107215_ + this.f_107217_ * this.f_107217_))) {
                                CommonMath.Angle angle = CommonMath.Angle.random();
                                double motion = Math.max(this.f_107216_ * reduction, 0.1);
                                this.f_107215_ = angle.cos() * motion;
                                this.f_107217_ = angle.sin() * motion;
                            }
                            this.f_107216_ = -this.f_107216_ * reduction;
                            break;
                        }
                        default: {
                            this.m_107274_();
                            return;
                        }
                    }
                    nextPos = hitLocation.add(bounceVec);
                    this.moveTo(nextPos);
                    return;
                }
            }
            this.hitAfterHitCount = 0;
            this.setPosition(nextPos);
        }

        public abstract ParticleRenderType m_7556_();

        protected void updatePoisonEffect() {
            if (this.poisonEffectUpdateInterval.pastIn((Level)this.f_107208_)) {
                AABB aabb = this.insideChimney ? this.m_107277_().m_165887_((double)GameWorld.SmokeContainers.getBottommostChimney((LevelReader)this.f_107208_, (BlockPos)this.getBlockPos()).m_123342_()) : this.m_107277_().m_82400_(0.5);
                this.f_107208_.m_6443_(LivingEntity.class, aabb, entity -> entity.m_6084_() && aabb.m_82390_(entity.m_146892_())).forEach(living -> new SmokePoisonEffectMsg((LivingEntity)living).sendToServer());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Factory<T extends ParticleOptions>
    implements ParticleProvider<T> {
        protected final SpriteSet sprite;

        public Factory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public abstract Particle m_6966_(T var1, ClientLevel var2, double var3, double var5, double var7, double var9, double var11, double var13);
    }

    public static abstract class Deserializer<T extends ParticleOptions>
    implements ParticleOptions.Deserializer<T> {
    }

    public static abstract class Data
    implements ParticleOptions {
        public final IWind wind;
        public final Smoke smoke;

        public Data(IWind wind, Smoke smoke) {
            this.wind = wind;
            this.smoke = smoke;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
        }

        public String m_5942_() {
            return BuiltInRegistries.f_257034_.m_7981_((Object)this.m_6012_()).toString();
        }
    }
}

