/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.mechanicalbotania.blocks;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import net.micaxs.mechanicalbotania.CommonConfig;
import net.micaxs.mechanicalbotania.blocks.ManaMotor;
import net.micaxs.mechanicalbotania.flowers.SpineretteBlockEntity;
import net.micaxs.mechanicalbotania.init.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.api.block.Bound;

public class ManaMotorBlockEntity
extends GeneratingKineticBlockEntity {
    private BlockPos[] boundFlowers = new BlockPos[]{Bound.UNBOUND_POS, Bound.UNBOUND_POS, Bound.UNBOUND_POS, Bound.UNBOUND_POS, Bound.UNBOUND_POS};
    private int numberBoundFlowers = 0;
    private int baseStress = (Integer)CommonConfig.baseStress.get();
    private static final int maxBound = 5;

    public ManaMotorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.MANAMOTOR.get(), pos, state);
        this.setLazyTickRate(20);
    }

    public boolean canAcceptFlower() {
        return this.numberBoundFlowers < 5;
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public void removeBoundFlower(BlockPos pos) {
        for (int i = 0; i < 5; ++i) {
            if (this.boundFlowers[i].m_123341_() != pos.m_123341_() || this.boundFlowers[i].m_123342_() != pos.m_123342_() || this.boundFlowers[i].m_123343_() != pos.m_123343_()) continue;
            this.boundFlowers[i] = Bound.UNBOUND_POS;
            this.numberBoundFlowers = Math.max(0, this.numberBoundFlowers - 1);
            this.updateGeneratedRotation();
            this.updateSpeed = true;
            this.calculateAddedStressCapacity();
        }
    }

    public void addBoundFlower(BlockPos pos) {
        boolean flowerAdded = false;
        for (int i = 0; i < 5; ++i) {
            if (this.boundFlowers[i].m_123342_() != Integer.MIN_VALUE || flowerAdded) continue;
            this.boundFlowers[i] = pos;
            flowerAdded = true;
            ++this.numberBoundFlowers;
            this.updateGeneratedRotation();
            this.updateSpeed = true;
            this.calculateAddedStressCapacity();
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (this.boundFlowers != null) {
            ListTag listTag = compound.m_128437_("BOUND_FLOWERS", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag subTag = listTag.m_128728_(i);
                this.boundFlowers[i] = new BlockPos(subTag.m_128451_("TAG_BIND_X"), subTag.m_128451_("TAG_BIND_Y"), subTag.m_128451_("TAG_BIND_Z"));
            }
            this.numberBoundFlowers = compound.m_128451_("NUMBER_BOUND_FLOWERS");
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (this.boundFlowers != null) {
            ListTag list = new ListTag();
            for (int i = 0; i < this.boundFlowers.length; ++i) {
                BlockPos pos = this.boundFlowers[i];
                CompoundTag sub = new CompoundTag();
                sub.m_128405_("TAG_BIND_X", pos.m_123341_());
                sub.m_128405_("TAG_BIND_Y", pos.m_123342_());
                sub.m_128405_("TAG_BIND_Z", pos.m_123343_());
                list.add(i, (Tag)sub);
            }
            compound.m_128365_("BOUND_FLOWERS", (Tag)list);
            compound.m_128405_("NUMBER_BOUND_FLOWERS", this.numberBoundFlowers);
        }
    }

    public float getRPM() {
        float rpm = 0.0f;
        for (BlockPos boundFlower : this.boundFlowers) {
            if (boundFlower == Bound.UNBOUND_POS || !(this.f_58857_.m_7702_(boundFlower) instanceof SpineretteBlockEntity)) continue;
            SpineretteBlockEntity spinerette = (SpineretteBlockEntity)this.f_58857_.m_7702_(boundFlower);
            rpm = spinerette != null ? Math.min(256.0f, rpm + (float)spinerette.getRpm()) : 0.0f;
        }
        return rpm;
    }

    public float getGeneratedSpeed() {
        return ManaMotorBlockEntity.convertToDirection((float)this.getRPM(), (Direction)((Direction)this.m_58900_().m_61143_((Property)ManaMotor.FACING)));
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = (float)Math.round((float)this.baseStress / ((float)this.numberBoundFlowers * (this.getRPM() / 8.0f) * 4.0f));
        return capacity;
    }

    public void destroy() {
        for (BlockPos boundFlower : this.boundFlowers) {
            SpineretteBlockEntity blockEntity;
            if (boundFlower == Bound.UNBOUND_POS || !(this.f_58857_.m_7702_(boundFlower) instanceof SpineretteBlockEntity) || (blockEntity = (SpineretteBlockEntity)this.f_58857_.m_7702_(boundFlower)) == null) continue;
            blockEntity.setBindPos(Bound.UNBOUND_POS);
            blockEntity.sync();
        }
        super.destroy();
    }
}

