/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.mechanicalbotania.flowers;

import java.util.List;
import net.micaxs.mechanicalbotania.CommonConfig;
import net.micaxs.mechanicalbotania.blocks.ManaMotorBlockEntity;
import net.micaxs.mechanicalbotania.data.BlockTagProvider;
import net.micaxs.mechanicalbotania.init.BlockEntityRegistry;
import net.micaxs.mechanicalbotania.init.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block.Bound;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.proxy.Proxy;

public class SpineretteBlockEntity
extends FunctionalFlowerBlockEntity {
    public final List<? extends Integer> RPMValues = (List)CommonConfig.RPMValues.get();
    private final int manaCost = (Integer)CommonConfig.manaCost.get() / 5;
    private static final String TAG_BIND_X = "bindX";
    private static final String TAG_BIND_Y = "bindY";
    private static final String TAG_BIND_Z = "bindZ";
    private static final int BIND_RANGE = 6;
    private BlockPos bindPos = Bound.UNBOUND_POS;
    private int rpm;

    public SpineretteBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.SPINERETTE.get(), pos, state);
    }

    public int getMaxMana() {
        return 2000;
    }

    public int getColor() {
        return 14203392;
    }

    public RadiusDescriptor getRadius() {
        return null;
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.ticksExisted % 4 == 0 && !this.f_58857_.f_46443_ && this.getMana() > 0) {
            ManaMotorBlockEntity mm;
            BlockState soil = this.f_58857_.m_8055_(this.m_58899_().m_7495_());
            if (this.bindPos.m_123342_() != Integer.MIN_VALUE) {
                this.addMana(-this.manaCost);
            }
            if (this.ticksExisted % 20 == 0 && this.bindPos != Bound.UNBOUND_POS && (mm = (ManaMotorBlockEntity)this.f_58857_.m_7702_(this.bindPos)) != null) {
                mm.updateGeneratedRotation();
                mm.updateSpeed = true;
                mm.calculateAddedStressCapacity();
                mm.m_6596_();
            }
            this.rpm = soil.m_204336_(BlockTagProvider.PoorestSoil) ? this.RPMValues.get(0) : (soil.m_204336_(BlockTagProvider.PoorSoil) ? this.RPMValues.get(1) : (soil.m_204336_(BlockTagProvider.MediumSoil) ? this.RPMValues.get(2) : (soil.m_204336_(BlockTagProvider.GoodSoil) ? this.RPMValues.get(3) : (soil.m_204336_(BlockTagProvider.BestSoil) ? this.RPMValues.get(4) : 0))));
            if (this.getMana() == 0) {
                BlockEntity blockEntity;
                this.rpm = 0;
                if (this.bindPos.m_123342_() != Integer.MIN_VALUE && (blockEntity = this.f_58857_.m_7702_(this.bindPos)) instanceof ManaMotorBlockEntity) {
                    ManaMotorBlockEntity be = (ManaMotorBlockEntity)blockEntity;
                    be.updateGeneratedRotation();
                    be.updateSpeed = true;
                    be.calculateAddedStressCapacity();
                    be.m_6596_();
                }
            }
        }
    }

    public void setBindPos(BlockPos bindPos) {
        this.bindPos = bindPos;
    }

    public BlockPos getBindPos() {
        return this.bindPos;
    }

    public RadiusDescriptor getSecondaryRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)6);
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_("RPM", this.rpm);
        cmp.m_128405_(TAG_BIND_X, this.bindPos.m_123341_());
        cmp.m_128405_(TAG_BIND_Y, this.bindPos.m_123342_());
        cmp.m_128405_(TAG_BIND_Z, this.bindPos.m_123343_());
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.rpm = cmp.m_128451_("RPM");
        this.bindPos = new BlockPos(cmp.m_128451_(TAG_BIND_X), cmp.m_128451_(TAG_BIND_Y), cmp.m_128451_(TAG_BIND_Z));
    }

    public boolean bindTo(Player player, ItemStack wand, BlockPos pos, Direction side) {
        BlockEntity blockEntity;
        boolean bound = super.bindTo(player, wand, pos, side);
        if (!bound && !pos.equals((Object)this.bindPos) && pos.m_123331_((Vec3i)this.getEffectivePos()) <= 6.0 && !pos.equals((Object)this.getEffectivePos()) && this.f_58857_.m_8055_(pos).m_60734_() == BlockRegistry.MANAMOTOR.get() && (blockEntity = this.f_58857_.m_7702_(pos)) instanceof ManaMotorBlockEntity) {
            ManaMotorBlockEntity manaMotor = (ManaMotorBlockEntity)blockEntity;
            if (manaMotor.canAcceptFlower()) {
                BlockEntity blockEntity2 = this.f_58857_.m_7702_(this.bindPos);
                if (blockEntity2 instanceof ManaMotorBlockEntity) {
                    ManaMotorBlockEntity mm = (ManaMotorBlockEntity)blockEntity2;
                    if (this.bindPos != pos) {
                        mm.removeBoundFlower(this.f_58858_);
                    }
                }
                this.bindPos = pos;
                this.sync();
                manaMotor.addBoundFlower(this.f_58858_);
                return true;
            }
            return false;
        }
        return bound;
    }

    public BlockPos getBinding() {
        return Proxy.INSTANCE.getClientPlayer().m_6144_() && this.bindPos.m_123342_() != Integer.MIN_VALUE ? this.bindPos : super.getBinding();
    }

    public int getRpm() {
        return this.rpm;
    }
}

