/*
 * Decompiled with CFR 0.152.
 */
package yaboichips.charms;

import com.mojang.logging.LogUtils;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.SlotTypeMessage;
import yaboichips.charms.client.gui.AdvancedContainerScreen;
import yaboichips.charms.client.gui.CharmContainerScreen;
import yaboichips.charms.client.gui.UltamiteContainerScreen;
import yaboichips.charms.core.CharmBlocks;
import yaboichips.charms.core.CharmContainerTypes;
import yaboichips.charms.core.CharmItems;
import yaboichips.charms.core.CharmTileEntityTypes;
import yaboichips.charms.util.CharmsConfig;
import yaboichips.charms.util.CuriosModCheck;
import yaboichips.charms.util.events.CharmProperties;

@Mod(value="charms")
public class Charms {
    public static final String MOD_ID = "charms";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Charms() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)new CharmProperties());
        CharmBlocks.BLOCKS.register(modEventBus);
        CharmItems.ITEMS.register(modEventBus);
        CharmItems.CREATIVE_MODE_TABS.register(modEventBus);
        CharmContainerTypes.MENUS.register(modEventBus);
        CharmTileEntityTypes.BLOCK_ENTITY.register(modEventBus);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::enqueueIMC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CharmsConfig.getConfigSpec(), "charms.toml");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void clientSetup(FMLClientSetupEvent e) {
        LOGGER.debug("Charms: Client Setup event starting...");
        MenuScreens.m_96206_((MenuType)((MenuType)CharmContainerTypes.CHARM_CONTAINER.get()), CharmContainerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)CharmContainerTypes.ULTIMATE_CHARM_CONTAINER.get()), UltamiteContainerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)CharmContainerTypes.ADVANCED_CHARM_CONTAINER.get()), AdvancedContainerScreen::new);
    }

    private void enqueueIMC(InterModEnqueueEvent e) {
        InterModComms.sendTo((String)MOD_ID, (String)"helloworld", () -> {
            LOGGER.info("Hello world from Charms");
            return "Hello world";
        });
        if (CuriosModCheck.CURIOS.isLoaded()) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("charm").size(CharmsConfig.getInstance().charmSlots()).build());
        }
    }
}

