/*
 * Decompiled with CFR 0.152.
 */
package yaboichips.charms.common.items;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import yaboichips.charms.common.items.CharmItem;

public class BounceCharm
extends CharmItem
implements ICurioItem {
    public BounceCharm(Item.Properties properties) {
        super(properties, null, 0);
    }

    @Override
    public void playRightClickEquipSound(LivingEntity livingEntity, ItemStack stack) {
        livingEntity.m_9236_().m_5594_(null, livingEntity.m_20183_(), SoundEvents.f_11674_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    @Override
    public boolean canRightClickEquip(ItemStack stack) {
        return true;
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player entity = (Player)slotContext.entity();
        BounceCharm.checkAndBouncePlayer(entity);
    }

    public static void checkAndBouncePlayer(Player player) {
        if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.m_20096_()) {
                double savedYVelocity = player.getPersistentData().m_128459_("savedYVelocity");
                double lookAngle = Math.toRadians(player.m_146908_());
                double horizontalBoost = Math.abs(savedYVelocity) * 0.3;
                double xBoost = -Math.sin(lookAngle) * horizontalBoost;
                double zBoost = Math.cos(lookAngle) * horizontalBoost;
                if (Math.abs(savedYVelocity) > 0.5) {
                    double bounceVelocity = savedYVelocity * 0.8;
                    Vec3 velocity = new Vec3(player.m_20184_().f_82479_ + xBoost, -bounceVelocity, player.m_20184_().f_82481_ + zBoost);
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(serverPlayer.m_19879_(), velocity));
                    serverPlayer.m_20256_(velocity);
                    player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12390_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    savedYVelocity *= -0.6;
                    if (Math.abs(savedYVelocity) < 0.3) {
                        savedYVelocity = 0.0;
                    }
                    player.getPersistentData().m_128347_("savedYVelocity", savedYVelocity);
                } else {
                    player.getPersistentData().m_128347_("savedYVelocity", 0.0);
                }
            } else {
                player.getPersistentData().m_128347_("savedYVelocity", player.m_20184_().f_82480_);
            }
        }
    }
}

