/*
 * Decompiled with CFR 0.152.
 */
package yaboichips.charms.common.tileentitys;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import yaboichips.charms.common.blocks.CharmContainerBlock;
import yaboichips.charms.common.container.CharmContainer;
import yaboichips.charms.common.items.CharmItem;
import yaboichips.charms.common.items.UpgradedCharmItem;
import yaboichips.charms.core.CharmTileEntityTypes;

public class CharmContainerTE
extends RandomizableContainerBlockEntity {
    private final IItemHandlerModifiable items = this.createHandler();
    private final LazyOptional<IItemHandlerModifiable> itemHandler = LazyOptional.of(() -> this.items);
    protected int numPlayersUsing;
    private NonNullList<ItemStack> chestContents = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);

    public CharmContainerTE(BlockPos pos, BlockState state) {
        super((BlockEntityType)CharmTileEntityTypes.CHARM_CONTAINER.get(), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, CharmContainerTE tile) {
        tile.addEffectsToPlayers(world);
    }

    public int m_6643_() {
        return 1;
    }

    public int m_6893_() {
        return 64;
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.chestContents;
    }

    public void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.chestContents = itemsIn;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.charm_container");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new CharmContainer(id, player, (Container)this);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.chestContents);
        }
    }

    public void m_142466_(CompoundTag p_155055_) {
        super.m_142466_(p_155055_);
        this.chestContents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(p_155055_)) {
            ContainerHelper.m_18980_((CompoundTag)p_155055_, this.chestContents);
        }
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.m_7531_(id, type);
    }

    public void m_5856_(Player player) {
        if (!player.m_5833_()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void m_5785_(Player player) {
        if (!player.m_5833_()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof CharmContainerBlock) {
            this.f_58857_.m_7696_(this.f_58858_, block, 1, this.numPlayersUsing);
            this.f_58857_.m_46672_(this.f_58858_, block);
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nonnull Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return super.getCapability(cap);
    }

    private IItemHandlerModifiable createHandler() {
        return new InvWrapper((Container)this);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
        }
    }

    public void addEffectsToPlayers(Level world) {
        if (!world.f_46443_) {
            for (int i = 0; i < this.m_6643_(); ++i) {
                AABB axisalignedbb = new AABB(this.f_58858_).m_82400_(10.0).m_82363_(0.0, (double)world.m_151558_(), 0.0);
                Item itemInSlot = this.m_8020_(i).m_41720_();
                List list = world.m_45976_(Player.class, axisalignedbb);
                for (Player playerentity : list) {
                    if (!(itemInSlot instanceof CharmItem)) continue;
                    CharmItem charm = (CharmItem)itemInSlot;
                    if (charm.getCharmEffect() != null) {
                        playerentity.m_7292_(new MobEffectInstance(charm.getCharmEffect(), charm.length));
                    }
                    if (!(itemInSlot instanceof UpgradedCharmItem)) continue;
                    UpgradedCharmItem upcharm = (UpgradedCharmItem)itemInSlot;
                    if (charm.getCharmEffect() == null) continue;
                    playerentity.m_7292_(new MobEffectInstance(upcharm.getCharmEffect(), upcharm.length, 1));
                }
            }
        }
    }
}

