/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations;

import com.blakebr0.mysticalagriculture.item.tool.EssenceBowItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceCrossbowItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceFishingRodItem;
import com.focamacho.mysticaladaptations.config.ConfigHolder;
import com.focamacho.mysticaladaptations.config.ConfigMysticalAdaptations;
import com.focamacho.mysticaladaptations.handlers.MobDropsHandler;
import com.focamacho.mysticaladaptations.handlers.TooltipHandler;
import com.focamacho.mysticaladaptations.init.ModAugments;
import com.focamacho.mysticaladaptations.init.ModItems;
import com.focamacho.mysticaladaptations.init.ModRegistry;
import com.focamacho.mysticaladaptations.util.Utils;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mysticaladaptations")
public class MysticalAdaptations {
    private static final Logger LOGGER = LogManager.getLogger();

    public MysticalAdaptations() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigMysticalAdaptations.spec);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new MobDropsHandler());
        ModRegistry.register();
    }

    private void setup(FMLCommonSetupEvent event) {
        ConfigHolder.updateConfigs();
        if (Utils.isVampirismLoaded) {
            if (!ConfigHolder.thirstlessAugment) {
                ModAugments.THIRSTLESS.setEnabled(false);
            }
            if (!ConfigHolder.daywalkerAugment) {
                ModAugments.DAYWALKER.setEnabled(false);
            }
        }
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new TooltipHandler());
        ModRegistry.registerClient();
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ModItems.INSANIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INSANIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INSANIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INSANIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INSANIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INSANIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INSANIUM_FISHING_ROD.get()), (ResourceLocation)new ResourceLocation("cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
        });
    }

    @SubscribeEvent
    public void onModConfigEvent(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigMysticalAdaptations.spec) {
            ConfigHolder.updateConfigs();
        }
    }
}

