/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.ars_botania.mana;

import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateMana;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.ars_botania.ArsBotania;
import studio.fantasyit.ars_botania.Config;
import studio.fantasyit.ars_botania.api.IArsManaCap;
import studio.fantasyit.ars_botania.data.ConvertEnums;
import studio.fantasyit.ars_botania.utils.DoubleAccumulator;
import vazkii.botania.api.mana.ManaItem;

public class FakeManaCap
implements ManaItem {
    @Nullable
    public DoubleAccumulator accumulator;
    @Nullable
    public DoubleAccumulator storeAccumulator;
    IManaCap cap;
    Player ars_botania$player;

    public DoubleAccumulator getAccumulator() {
        if (this.accumulator == null) {
            this.accumulator = new DoubleAccumulator(ConvertEnums.getWhenPlayerUsePlayerSourceAndWillBeConvertedToBotaniaMana());
        }
        return this.accumulator;
    }

    public DoubleAccumulator getStoreAccumulator() {
        if (this.storeAccumulator == null) {
            this.storeAccumulator = new DoubleAccumulator(ConvertEnums.getWhenPlayerReceiveBotaniaManaAndWillBeConvertedToPlayerSource());
        }
        return this.storeAccumulator;
    }

    public void setPlayer(Player player) {
        this.ars_botania$player = player;
    }

    public void setCap(@NotNull IManaCap cap) {
        this.cap = cap;
    }

    public int getMana() {
        if (this.cap == null) {
            return 0;
        }
        return (int)this.getAccumulator().inner2outer(((IArsManaCap)this.cap).ars_botania$getRawMana());
    }

    public int getMaxMana() {
        if (this.cap == null) {
            return 0;
        }
        return this.getAccumulator().inner2outer(((IArsManaCap)this.cap).ars_botania$getRawMaxMana());
    }

    public void addMana(int i) {
        if (i < 0) {
            int realAdd = this.getAccumulator().takeAndGetCost(-i);
            this.cap.removeMana((double)realAdd);
        } else if (Config.playerManaRecoveryChargeItem) {
            int realAdd = this.getStoreAccumulator().accumulateAndGet(i);
            this.cap.addMana((double)realAdd);
        }
        this.syncCap();
    }

    public boolean canReceiveManaFromPool(BlockEntity blockEntity) {
        return false;
    }

    public boolean canReceiveManaFromItem(ItemStack itemStack) {
        return !itemStack.m_150930_((Item)ArsBotania.FAKE_MANA_ITEM.get());
    }

    public boolean canExportManaToPool(BlockEntity blockEntity) {
        return false;
    }

    public boolean canExportManaToItem(ItemStack itemStack) {
        return !itemStack.m_150930_((Item)ArsBotania.FAKE_MANA_ITEM.get());
    }

    public boolean isNoExport() {
        return false;
    }

    protected void syncCap() {
        Player player = this.ars_botania$player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (this.cap != null) {
                Networking.sendToPlayerClient((Object)new PacketUpdateMana(((IArsManaCap)this.cap).ars_botania$getRawMana(), ((IArsManaCap)this.cap).ars_botania$getRawMaxMana(), this.cap.getGlyphBonus(), this.cap.getBookTier()), (ServerPlayer)sp);
            }
        }
    }
}

