/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.ars_botania.mixin;

import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import studio.fantasyit.ars_botania.api.IReceiveOrGiveMana;
import studio.fantasyit.ars_botania.data.ConvertEnums;
import studio.fantasyit.ars_botania.utils.DoubleAccumulator;

@Mixin(value={AbstractSourceMachine.class}, remap=false)
public abstract class ArsReceiveOrGiveManaPool
extends ModdedTile
implements IReceiveOrGiveMana {
    @Shadow
    private int source;
    @Nullable
    public DoubleAccumulator accumulator;

    @Shadow
    public abstract int getMaxSource();

    @Shadow
    public abstract int getSource();

    @Shadow
    public abstract int setSource(int var1);

    @Shadow
    public abstract int addSource(int var1);

    @Shadow
    public abstract int removeSource(int var1);

    public DoubleAccumulator getAccumulator() {
        if (this.accumulator == null) {
            this.accumulator = new DoubleAccumulator(ConvertEnums.getWhenManaWasPutIntoOrTakeOutFromSourceContainer());
        }
        return this.accumulator;
    }

    public ArsReceiveOrGiveManaPool(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public boolean isOutputtingPower() {
        return false;
    }

    public int getMaxMana() {
        return this.getAccumulator().inner2outer(this.getMaxSource());
    }

    public Optional<DyeColor> getColor() {
        return Optional.of(DyeColor.PURPLE);
    }

    public void setColor(Optional<DyeColor> optional) {
    }

    public Level getManaReceiverLevel() {
        return this.f_58857_;
    }

    public BlockPos getManaReceiverPos() {
        return this.f_58858_;
    }

    public int getCurrentMana() {
        return this.getAccumulator().inner2outer(this.getSource());
    }

    public boolean isFull() {
        return this.getSource() >= this.getMaxSource();
    }

    public void receiveMana(int i) {
        if (i <= 0) {
            this.removeSource(this.getAccumulator().accumulateAndGet(i));
        } else {
            this.addSource(this.getAccumulator().accumulateAndGet(i));
        }
    }

    public boolean canReceiveManaFromBursts() {
        return !this.isFull();
    }
}

