/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command.argument;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.ApiStatus;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.argument.RegistryTagSource;
import slimeknights.mantle.command.argument.ResourceOrTagKeyArgument;
import slimeknights.mantle.command.argument.TagSource;

public class TagSourceArgument {
    private static final DynamicCommandExceptionType NOT_FOUND = new DynamicCommandExceptionType(name -> Component.m_237110_((String)"command.mantle.tag_source.not_found", (Object[])new Object[]{name}));
    private static final Map<ResourceKey<? extends Registry<?>>, TagSource<?>> CUSTOM_TAG_SOURCES = new HashMap();
    public static SuggestionProvider<CommandSourceStack> SOURCE;
    public static SuggestionProvider<CommandSourceStack> TAG;
    public static SuggestionProvider<CommandSourceStack> VALUE;
    public static SuggestionProvider<CommandSourceStack> ENTRY;

    @ApiStatus.Internal
    public static void registerSuggestions() {
        SOURCE = SuggestionProviders.m_121658_((ResourceLocation)Mantle.getResource("tag_source"), (context, builder) -> SharedSuggestionProvider.m_82957_(TagSourceArgument.allKeys((CommandContext<? extends SharedSuggestionProvider>)context).map(ResourceKey::m_135782_), (SuggestionsBuilder)builder));
        TAG = SuggestionProviders.m_121658_((ResourceLocation)Mantle.getResource("tag_source_tag"), (context, builder) -> {
            TagSource<?> result = TagSourceArgument.get((CommandContext<? extends SharedSuggestionProvider>)context);
            return SharedSuggestionProvider.m_82957_(result.tagKeys().map(TagKey::f_203868_), (SuggestionsBuilder)builder);
        });
        VALUE = SuggestionProviders.m_121658_((ResourceLocation)Mantle.getResource("tag_source_value"), (context, builder) -> {
            TagSource<?> result = TagSourceArgument.get((CommandContext<? extends SharedSuggestionProvider>)context);
            return SharedSuggestionProvider.m_82957_(result.valueKeys(), (SuggestionsBuilder)builder);
        });
        ENTRY = SuggestionProviders.m_121658_((ResourceLocation)Mantle.getResource("tag_source_entry"), (context, builder) -> {
            TagSource<?> result = TagSourceArgument.get((CommandContext<? extends SharedSuggestionProvider>)context);
            SharedSuggestionProvider.m_82957_(result.valueKeys(), (SuggestionsBuilder)builder);
            SharedSuggestionProvider.m_205106_(result.tagKeys().map(TagKey::f_203868_), (SuggestionsBuilder)builder, (String)"#");
            return builder.buildFuture();
        });
    }

    public static <T> TagSource<T> registerCustom(TagSource<T> source) {
        TagSource<T> existing = CUSTOM_TAG_SOURCES.putIfAbsent(source.key(), source);
        if (existing != null) {
            throw new IllegalArgumentException("Duplicate custom tag source: " + source.key());
        }
        return source;
    }

    public static ArgumentType<ResourceLocation> source() {
        return ResourceLocationArgument.m_106984_();
    }

    public static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> argument() {
        return Commands.m_82129_((String)"type", TagSourceArgument.source()).suggests(SOURCE);
    }

    public static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> tagArgument(String key) {
        return Commands.m_82129_((String)key, (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(TAG);
    }

    public static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> valueArgument(String key) {
        return Commands.m_82129_((String)key, (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(VALUE);
    }

    public static RequiredArgumentBuilder<CommandSourceStack, ResourceOrTagKeyArgument.Result> entryArgument(String key) {
        return Commands.m_82129_((String)key, ResourceOrTagKeyArgument.key()).suggests(ENTRY);
    }

    public static Stream<TagSource<?>> allSources(CommandContext<? extends SharedSuggestionProvider> context) {
        return Stream.concat(((SharedSuggestionProvider)context.getSource()).m_5894_().m_206193_().map(entry -> new RegistryTagSource(entry.f_206234_())), CUSTOM_TAG_SOURCES.values().stream());
    }

    public static Stream<ResourceKey<? extends Registry<?>>> allKeys(CommandContext<? extends SharedSuggestionProvider> context) {
        return Stream.concat(((SharedSuggestionProvider)context.getSource()).m_5894_().m_206193_().map(RegistryAccess.RegistryEntry::f_206233_), CUSTOM_TAG_SOURCES.keySet().stream());
    }

    public static TagSource<?> get(CommandContext<? extends SharedSuggestionProvider> context) throws CommandSyntaxException {
        ResourceLocation id = (ResourceLocation)context.getArgument("type", ResourceLocation.class);
        ResourceKey key = ResourceKey.m_135788_((ResourceLocation)id);
        TagSource<?> custom = CUSTOM_TAG_SOURCES.get(key);
        if (custom != null) {
            return custom;
        }
        return new RegistryTagSource((Registry)((SharedSuggestionProvider)context.getSource()).m_5894_().m_6632_(key).orElseThrow(() -> NOT_FOUND.create((Object)id)));
    }
}

