/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.listener;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import slimeknights.mantle.data.listener.IEarlySafeManagerReloadListener;

public class ResourceValidator
implements IEarlySafeManagerReloadListener,
Predicate<ResourceLocation> {
    private final String folder;
    private final int trim;
    private final String extension;
    protected Set<ResourceLocation> resources;

    public ResourceValidator(String folder, String trim, String extension) {
        this.folder = folder;
        this.trim = trim.length() + 1;
        this.extension = extension;
        this.resources = Set.of();
    }

    @Override
    public void onReloadSafe(ResourceManager manager) {
        int extensionLength = this.extension.length();
        this.resources = manager.m_214159_(this.folder, loc -> loc.m_135815_().endsWith(this.extension)).keySet().stream().map(location -> {
            String path = location.m_135815_();
            return new ResourceLocation(location.m_135827_(), path.substring(this.trim, path.length() - extensionLength));
        }).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public boolean test(ResourceLocation location) {
        return this.resources.contains(location);
    }

    public void clear() {
        this.resources = Set.of();
    }
}

