/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class Button
implements IPanelCell,
IPanelCellInfoProvider {
    public static ResourceLocation TEXTURE_OAK_PLANKS = new ResourceLocation("minecraft", "block/oak_planks");
    protected boolean active = false;
    protected Integer ticksRemaining = 0;
    protected Side baseSide = Side.BOTTOM;

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        TextureAtlasSprite sprite = this.getSprite();
        VertexConsumer builder = buffer.m_6299_((double)alpha == 1.0 ? RenderType.m_110451_() : RenderType.m_110466_());
        if (this.baseSide == Side.FRONT) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            matrixStack.m_85837_(0.0, 0.0, this.active ? -0.9375 : -0.875);
        } else if (this.baseSide == Side.TOP) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            matrixStack.m_85837_(0.0, -1.0, this.active ? -0.9375 : -0.875);
        } else {
            matrixStack.m_85837_(0.0, 0.0, this.active ? 0.0625 : 0.125);
        }
        float x1 = 0.3125f;
        float x2 = 0.6875f;
        float y1 = 0.375f;
        float y2 = 0.625f;
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, sprite, combinedLight, alpha);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStack.m_85837_(0.0, -0.125, (double)(-y1));
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, 0.0f, 0.125f, sprite, combinedLight, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, 0.6875);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.25f, 0.0f, 0.125f, sprite, combinedLight, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, 0.25);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.375f, 0.0f, 0.125f, sprite, combinedLight, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, 0.375);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.25f, 0.0f, 0.125f, sprite, combinedLight, alpha);
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        return false;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        return this.active && outputDirection != this.baseSide.getOpposite() ? 15 : 0;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        return this.active && outputDirection == this.baseSide ? 15 : 0;
    }

    @Override
    public boolean isIndependentState() {
        return true;
    }

    @Override
    public boolean needsSolidBase() {
        return true;
    }

    @Override
    public Side getBaseSide() {
        return this.baseSide;
    }

    @Override
    public void setBaseSide(Side side) {
        this.baseSide = side;
    }

    @Override
    public boolean tick(PanelCellPos cellPos) {
        if (this.active && this.ticksRemaining > 0) {
            Integer n = this.ticksRemaining;
            this.ticksRemaining = this.ticksRemaining - 1;
            if (this.ticksRemaining == 0) {
                this.active = false;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, Player player) {
        if (!this.active) {
            PanelTile panelTile = cellPos.getPanelTile();
            panelTile.m_58904_().m_7785_((double)panelTile.m_58899_().m_123341_(), (double)panelTile.m_58899_().m_123342_(), (double)panelTile.m_58899_().m_123343_(), SoundEvents.f_12632_, SoundSource.BLOCKS, 0.25f, 2.0f, false);
            this.active = true;
            this.ticksRemaining = 30;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasActivation() {
        return true;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("active", this.active);
        nbt.m_128405_("ticksRemaining", this.ticksRemaining.intValue());
        nbt.m_128359_("baseSide", this.baseSide.name());
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag compoundNBT) {
        this.active = compoundNBT.m_128471_("active");
        this.ticksRemaining = compoundNBT.m_128451_("ticksRemaining");
        this.baseSide = compoundNBT.m_128461_("baseSide").length() > 0 ? Side.valueOf(compoundNBT.m_128461_("baseSide")) : Side.BOTTOM;
    }

    protected TextureAtlasSprite getSprite() {
        return RenderHelper.getSprite(TEXTURE_OAK_PLANKS);
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
        overlayBlockInfo.setPowerOutput(this.active ? 15 : 0);
    }

    @Override
    public PanelCellVoxelShape getShape() {
        if (this.baseSide == Side.BOTTOM) {
            return PanelCellVoxelShape.BUTTONSHAPE;
        }
        if (this.baseSide == Side.TOP) {
            return PanelCellVoxelShape.BUTTONSHAPE_TOP;
        }
        return PanelCellVoxelShape.BUTTONSHAPE_FRONT;
    }
}

