/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.RotationLock;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.LinkedList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3d;

public class Torch
implements IPanelCell {
    private boolean output = true;
    private int changePending = 0;
    private final LinkedList<Boolean> changeHx = new LinkedList();
    private boolean burnout = false;
    private boolean upright = false;
    private int changedTick = -1;
    public static ResourceLocation TEXTURE_TORCH_ON = new ResourceLocation("tinyredstone", "block/redstone_torch");
    public static ResourceLocation TEXTURE_TORCH_OFF = new ResourceLocation("tinyredstone", "block/redstone_torch_off");
    public static ResourceLocation TEXTURE_TORCH_TOP_ON = new ResourceLocation("tinyredstone", "block/redstone_torch_top");
    public static ResourceLocation TEXTURE_TORCH_TOP_OFF = new ResourceLocation("tinyredstone", "block/redstone_torch_top_off");
    private Side baseSide = Side.BOTTOM;

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        TextureAtlasSprite sprite_torch_top;
        TextureAtlasSprite sprite_torch;
        VertexConsumer builder = buffer.m_6299_((double)alpha == 1.0 ? RenderType.m_110451_() : RenderType.m_110466_());
        if (this.getWeakRsOutput(Side.FRONT) > 0) {
            sprite_torch = RenderHelper.getSprite(TEXTURE_TORCH_ON);
            sprite_torch_top = RenderHelper.getSprite(TEXTURE_TORCH_TOP_ON);
        } else {
            sprite_torch = RenderHelper.getSprite(TEXTURE_TORCH_OFF);
            sprite_torch_top = RenderHelper.getSprite(TEXTURE_TORCH_TOP_OFF);
        }
        float tU0 = sprite_torch.m_118409_();
        float tU1 = tU0 + (sprite_torch.m_118410_() - tU0) / 8.0f;
        float tV0 = sprite_torch.m_118411_();
        float tV1 = tV0 + (sprite_torch.m_118412_() - tV0) * 5.0f / 8.0f;
        float topU0 = sprite_torch_top.m_118409_();
        float topU1 = topU0 + (sprite_torch_top.m_118410_() - topU0) / 8.0f;
        float topV0 = sprite_torch_top.m_118411_();
        float topV1 = topV0 + (sprite_torch_top.m_118412_() - topV0) / 8.0f;
        float x1 = 0.375f;
        float x2 = 0.625f;
        float y1 = 0.0f;
        float y2 = 1.0f;
        if (this.upright) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            matrixStack.m_252880_(0.0f, 0.0f, -0.375f);
        } else if (this.baseSide == Side.FRONT) {
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            matrixStack.m_252880_(-1.0f, -1.125f, 0.125f);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(60.0f));
        } else {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(60.0f));
            matrixStack.m_252880_(0.0f, 0.03125f, 0.0f);
        }
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, tU0, tU1, tV0, tV1, this.output ? 0xF000F0 : combinedLight, -1, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(-x1, 0.0f, x2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, tU0, tU1, tV0, tV1, this.output ? 0xF000F0 : combinedLight, -1, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(-x1, 0.0f, x2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, tU0, tU1, tV0, tV1, this.output ? 0xF000F0 : combinedLight, -1, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(-x1, 0.0f, x2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, tU0, tU1, tV0, tV1, this.output ? 0xF000F0 : combinedLight, -1, alpha);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        matrixStack.m_252880_(0.0f, -x1, y2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, x1, x2, topU0, topU1, topV0, topV1, this.output ? 0xF000F0 : combinedLight, -1, alpha);
    }

    @Override
    public boolean onPlace(PanelCellPos cellPos, Player player) {
        if (RotationLock.getServerRotationLock(player) == null) {
            Direction panelFacing = (Direction)cellPos.getPanelTile().m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
            if ((switch (panelFacing) {
                case Direction.NORTH -> -player.m_20154_().f_82481_;
                case Direction.SOUTH -> player.m_20154_().f_82481_;
                case Direction.WEST -> -player.m_20154_().f_82479_;
                case Direction.EAST -> player.m_20154_().f_82479_;
                case Direction.UP -> player.m_20154_().f_82480_;
                default -> -player.m_20154_().f_82480_;
            }) > 0.95) {
                this.upright = true;
            }
        }
        this.neighborChanged(cellPos);
        return true;
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        this.changedTick = cellPos.getPanelTile().getRelTickTime();
        return false;
    }

    private void checkInputs(PanelCellPos cellPos) {
        boolean output;
        PanelCellNeighbor inputNeighbor = cellPos.getNeighbor(this.baseSide == Side.FRONT ? Side.FRONT : (this.upright ? Side.BOTTOM : Side.BACK));
        boolean bl = output = inputNeighbor == null || inputNeighbor.getWeakRsOutput() == 0;
        if (this.burnout && output) {
            int changes = 0;
            for (Boolean b : this.changeHx) {
                if (!b.booleanValue()) continue;
                ++changes;
            }
            if (changes <= 16) {
                this.burnout = false;
            }
            this.changePending = 2;
        }
        if (!this.burnout && output != this.output) {
            this.output = output;
            this.changePending = 2;
        }
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        if (!this.burnout && (this.baseSide == Side.FRONT && outputDirection != Side.FRONT || !this.upright && outputDirection != Side.BACK || this.upright && outputDirection != Side.BOTTOM) && (this.output && this.changePending == 0 || !this.output && this.changePending > 0)) {
            return 15;
        }
        return 0;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        if (outputDirection == Side.TOP && !this.burnout && (this.output && this.changePending == 0 || !this.output && this.changePending > 0)) {
            return 15;
        }
        return 0;
    }

    @Override
    public int lightOutput() {
        return (Boolean)Config.TORCH_LIGHT.get() != false && this.getWeakRsOutput(Side.FRONT) > 0 ? 1 : 0;
    }

    @Override
    public boolean tick(PanelCellPos cellPos) {
        if (this.changedTick > -1 && this.changedTick < cellPos.getPanelTile().getRelTickTime()) {
            this.checkInputs(cellPos);
            this.changedTick = -1;
        }
        boolean changed = false;
        this.changeHx.add(this.changePending == 2);
        if (this.changeHx.size() > 60) {
            this.changeHx.pop();
        }
        int changes = 0;
        for (Boolean b : this.changeHx) {
            if (!b.booleanValue()) continue;
            ++changes;
        }
        if (changes > 16) {
            this.burnout = true;
        }
        if (this.changePending > 1) {
            --this.changePending;
        } else if (this.changePending == 1) {
            --this.changePending;
            changed = true;
        }
        if (this.changedTick > -1) {
            this.checkInputs(cellPos);
            this.changedTick = -1;
        }
        return changed;
    }

    @Override
    public boolean needsSolidBase() {
        return true;
    }

    @Override
    public boolean canAttachToBaseOnSide(Side side) {
        return side != Side.TOP;
    }

    @Override
    public Side getBaseSide() {
        return this.baseSide;
    }

    @Override
    public void setBaseSide(Side side) {
        this.baseSide = side;
        if (side == Side.FRONT) {
            this.upright = false;
        }
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("output", this.output);
        nbt.m_128405_("changePending", this.changePending);
        nbt.m_128379_("burnout", this.burnout);
        nbt.m_128379_("upright", this.upright);
        nbt.m_128359_("baseSide", this.baseSide.name());
        StringBuilder changeHxString = new StringBuilder();
        for (Object b : this.changeHx.toArray()) {
            changeHxString.append((Boolean)b != false ? "1" : "0");
        }
        nbt.m_128359_("changeHx", changeHxString.toString());
        nbt.m_128405_("changedTick", this.changedTick);
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag compoundNBT) {
        this.output = compoundNBT.m_128471_("output");
        this.changePending = compoundNBT.m_128451_("changePending");
        this.burnout = compoundNBT.m_128471_("burnout");
        this.upright = compoundNBT.m_128471_("upright");
        this.baseSide = compoundNBT.m_128461_("baseSide").length() > 0 ? Side.valueOf(compoundNBT.m_128461_("baseSide")) : Side.BOTTOM;
        String changeHxString = compoundNBT.m_128461_("changeHx");
        byte[] byArray = changeHxString.getBytes();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte b = byArray[i];
            this.changeHx.add(b == 49);
            if (this.changeHx.size() <= 60) continue;
            this.changeHx.pop();
        }
        this.changedTick = compoundNBT.m_128451_("changedTick");
    }

    @Override
    public PanelCellVoxelShape getShape() {
        return new PanelCellVoxelShape(new Vector3d(0.25, 0.0, 0.25), new Vector3d(0.75, 1.0, 0.75));
    }
}

