/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jeresources.platform.Services;
import jeresources.profiling.ProfiledDimensionData;
import jeresources.profiling.ProfilingBlacklist;
import jeresources.profiling.ProfilingTimer;
import jeresources.util.MapKeys;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ChunkProfiler
implements Runnable {
    private final ServerLevel level;
    private final ResourceKey<Level> dimensionKey;
    private final ProfilingTimer timer;
    private final ProfilingBlacklist blacklist;
    private final List<ChunkAccess> chunks;
    @Nonnull
    private final ProfiledDimensionData dimensionData;
    public static final int CHUNK_SIZE = 16;
    public static final int CHUNK_HEIGHT = 256;

    public ChunkProfiler(ServerLevel level, ResourceKey<Level> dimensionKey, List<ChunkAccess> chunks, @Nonnull ProfiledDimensionData dimensionData, ProfilingTimer timer, ProfilingBlacklist blacklist) {
        this.level = level;
        this.dimensionKey = dimensionKey;
        this.chunks = chunks;
        this.dimensionData = dimensionData;
        this.timer = timer;
        this.blacklist = blacklist;
    }

    @Override
    public void run() {
        this.chunks.forEach(this::profileChunk);
    }

    private void profileChunk(ChunkAccess chunk) {
        ResourceKey worldRegistryKey = this.level.m_46472_();
        this.timer.startChunk((ResourceKey<Level>)worldRegistryKey);
        HashMap<String, Object[]> temp = new HashMap<String, Object[]>();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        BlockHitResult rayTraceResult = new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.DOWN, (BlockPos)blockPos, true);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int maxY = chunk.m_62098_();
        for (int y = 0; y < maxY; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Object[] array;
                    blockPos.m_122178_(x + chunk.m_7697_().f_45578_ * 16, y, z + chunk.m_7697_().f_45579_ * 16);
                    BlockState blockState = chunk.m_8055_(new BlockPos(x, y, z));
                    if (this.blacklist.contains(blockState)) continue;
                    String key = MapKeys.getKey(blockState, this.level, (BlockPos)blockPos);
                    if (!this.dimensionData.dropsMap.containsKey(key)) {
                        this.dimensionData.dropsMap.put(key, ChunkProfiler.getDrops(this.level, (BlockPos)blockPos, blockState));
                    }
                    if (!this.dimensionData.silkTouchMap.containsKey(key)) {
                        Block block = blockState.m_60734_();
                        boolean canSilkTouch = Services.PLATFORM.isCorrectToolForBlock(block, blockState, (BlockGetter)this.level, (BlockPos)blockPos, (Player)player);
                        this.dimensionData.silkTouchMap.put(key, canSilkTouch);
                    }
                    if ((array = (Integer[])temp.get(key)) == null) {
                        array = new Integer[256];
                        Arrays.fill(array, (Object)0);
                    }
                    Object[] objectArray = array;
                    int n = y;
                    Object object = objectArray[n];
                    objectArray[n] = (Integer)objectArray[n] + 1;
                    temp.put(key, array);
                }
            }
        }
        for (Map.Entry entry : temp.entrySet()) {
            Object[] array = (Integer[])this.dimensionData.distributionMap.get(entry.getKey());
            if (array == null) {
                array = new Integer[256];
                Arrays.fill(array, (Object)0);
            }
            for (int i = 0; i < 256; ++i) {
                Object[] objectArray = array;
                int n = i;
                Integer.valueOf((Integer)objectArray[n] + ((Integer[])entry.getValue())[i]);
            }
            this.dimensionData.distributionMap.put((String)entry.getKey(), (Integer[])array);
        }
        this.timer.endChunk(this.dimensionKey);
    }

    public static Map<String, Map<Integer, Float>> getDrops(ServerLevel level, BlockPos pos, BlockState state) {
        int totalTries = 10000;
        HashMap<String, Map<Integer, Float>> resultMap = new HashMap<String, Map<Integer, Float>>();
        for (int fortune = 0; fortune <= 3; ++fortune) {
            HashMap<String, Integer> dropsMap = new HashMap<String, Integer>();
            for (int i = 0; i < 10000; ++i) {
                NonNullList drops = NonNullList.m_122779_();
                Block.m_49869_((BlockState)state, (ServerLevel)level, (BlockPos)pos, null);
                for (ItemStack drop : drops) {
                    if (drop == null) continue;
                    String key = MapKeys.getKey(drop);
                    Integer count = (Integer)dropsMap.get(key);
                    count = count != null ? Integer.valueOf(count + drop.m_41613_()) : Integer.valueOf(drop.m_41613_());
                    dropsMap.put(key, count);
                }
            }
            for (Map.Entry dropEntry : dropsMap.entrySet()) {
                HashMap<Integer, Float> fortuneMap = (HashMap<Integer, Float>)resultMap.get(dropEntry.getKey());
                if (fortuneMap == null) {
                    fortuneMap = new HashMap<Integer, Float>();
                }
                fortuneMap.put(fortune, Float.valueOf((float)((Integer)dropEntry.getValue()).intValue() / 10000.0f));
                resultMap.put((String)dropEntry.getKey(), fortuneMap);
            }
        }
        return resultMap;
    }
}

