/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.event.MekanismTeleportEvent;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.math.FloatingLong;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.radial.mode.NestedRadialMode;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IBlastingItem;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.mekatool.ModuleAttackAmplificationUnit;
import mekanism.common.content.gear.mekatool.ModuleBlastingUnit;
import mekanism.common.content.gear.mekatool.ModuleExcavationEscalationUnit;
import mekanism.common.content.gear.mekatool.ModuleTeleportationUnit;
import mekanism.common.content.gear.mekatool.ModuleVeinMiningUnit;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.gear.ItemAtomicDisassembler;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.radial.IGenericRadialModeItem;
import mekanism.common.lib.radial.data.NestingRadialData;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.registries.MekanismModules;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMekaTool
extends ItemEnergized
implements IModuleContainerItem,
IBlastingItem,
IGenericRadialModeItem {
    private static final ResourceLocation RADIAL_ID = Mekanism.rl("meka_tool");
    private final Int2ObjectMap<AttributeCache> attributeCaches = new Int2ObjectArrayMap(ModuleAttackAmplificationUnit.AttackDamage.values().length);

    public ItemMekaTool(Item.Properties properties) {
        super(MekanismConfig.gear.mekaToolBaseChargeRate, MekanismConfig.gear.mekaToolBaseEnergyCapacity, properties.m_41497_(Rarity.EPIC).setNoRepair());
    }

    public boolean m_8096_(@NotNull BlockState state) {
        return true;
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed(MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
        } else {
            StorageUtils.addStoredEnergy(stack, tooltip, true);
            tooltip.add((Component)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.m_90863_()));
        }
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        if (ItemAtomicDisassembler.ALWAYS_SUPPORTED_ACTIONS.contains(action)) {
            return this.hasEnergyForDigAction(stack);
        }
        return this.getModules(stack).stream().anyMatch(module -> module.isEnabled() && this.canPerformAction((IModule)module, action));
    }

    private <MODULE extends ICustomModule<MODULE>> boolean canPerformAction(IModule<MODULE> module, ToolAction action) {
        return module.getCustomInstance().canPerformAction(module, action);
    }

    public boolean hasEnergyForDigAction(ItemStack stack) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null) {
            FloatingLong energyAvailable;
            FloatingLong energyRequired = this.getDestroyEnergy(stack, 0.0f, this.isModuleEnabled(stack, MekanismModules.SILK_TOUCH_UNIT));
            return energyRequired.smallerOrEqual(energyAvailable = energyContainer.getEnergy()) || !energyAvailable.divide(energyRequired).isZero();
        }
        return false;
    }

    public boolean isNotReplaceableByPickAction(ItemStack stack, Player player, int inventorySlot) {
        return super.isNotReplaceableByPickAction(stack, player, inventorySlot) || ItemDataUtils.hasData(stack, "modules", 10);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        if (stack.m_41619_()) {
            return 0;
        }
        ListTag enchantments = ItemDataUtils.getList(stack, "Enchantments");
        return Math.max(MekanismUtils.getEnchantmentLevel(enchantments, enchantment), super.getEnchantmentLevel(stack, enchantment));
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44882_((ListTag)ItemDataUtils.getList(stack, "Enchantments"));
        super.getAllEnchantments(stack).forEach((enchantment, level) -> enchantments.merge(enchantment, level, Math::max));
        return enchantments;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        for (Module module : this.getModules(context.m_43722_())) {
            InteractionResult result;
            if (!module.isEnabled() || (result = this.onModuleUse(module, context)) == InteractionResult.PASS) continue;
            return result;
        }
        return super.m_6225_(context);
    }

    private <MODULE extends ICustomModule<MODULE>> InteractionResult onModuleUse(IModule<MODULE> module, UseOnContext context) {
        return module.getCustomInstance().onItemUse(module, context);
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        for (Module module : this.getModules(stack)) {
            InteractionResult result;
            if (!module.isEnabled() || (result = this.onModuleInteract(module, player, entity, hand)) == InteractionResult.PASS) continue;
            return result;
        }
        return super.m_6880_(stack, player, entity, hand);
    }

    private <MODULE extends ICustomModule<MODULE>> InteractionResult onModuleInteract(IModule<MODULE> module, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        return module.getCustomInstance().onInteract(module, player, entity, hand);
    }

    public float m_8102_(@NotNull ItemStack stack, @NotNull BlockState state) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer == null) {
            return 0.0f;
        }
        FloatingLong energyRequired = this.getDestroyEnergy(stack, state.f_60599_, this.isModuleEnabled(stack, MekanismModules.SILK_TOUCH_UNIT));
        FloatingLong energyAvailable = energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL);
        if (energyAvailable.smallerThan(energyRequired)) {
            return MekanismConfig.gear.mekaToolBaseEfficiency.get() * energyAvailable.divide(energyRequired).floatValue();
        }
        IModule module = this.getModule(stack, MekanismModules.EXCAVATION_ESCALATION_UNIT);
        return module == null || !module.isEnabled() ? MekanismConfig.gear.mekaToolBaseEfficiency.get() : ((ModuleExcavationEscalationUnit)module.getCustomInstance()).getEfficiency();
    }

    public boolean m_6813_(@NotNull ItemStack stack, @NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entityliving) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null) {
            FloatingLong energyRequired = this.getDestroyEnergy(stack, state.m_60800_((BlockGetter)world, pos), this.isModuleEnabled(stack, MekanismModules.SILK_TOUCH_UNIT));
            energyContainer.extract(energyRequired, Action.EXECUTE, AutomationType.MANUAL);
        }
        return true;
    }

    public boolean m_7579_(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        IEnergyContainer energyContainer;
        int unitDamage;
        IModule attackAmplificationUnit = this.getModule(stack, MekanismModules.ATTACK_AMPLIFICATION_UNIT);
        if (attackAmplificationUnit != null && attackAmplificationUnit.isEnabled() && (unitDamage = ((ModuleAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getDamage()) > 0 && (energyContainer = StorageUtils.getEnergyContainer(stack, 0)) != null && !energyContainer.isEmpty()) {
            energyContainer.extract(((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageWeapon.get()).multiply((double)unitDamage / 4.0), Action.EXECUTE, AutomationType.MANUAL);
        }
        return true;
    }

    @Override
    public Map<BlockPos, BlockState> getBlastedBlocks(Level world, Player player, ItemStack stack, BlockPos pos, BlockState state) {
        int radius;
        IModule blastingUnit;
        if (!player.m_6144_() && (blastingUnit = this.getModule(stack, MekanismModules.BLASTING_UNIT)) != null && blastingUnit.isEnabled() && (radius = ((ModuleBlastingUnit)blastingUnit.getCustomInstance()).getBlastRadius()) > 0 && IBlastingItem.canBlastBlock(world, pos, state)) {
            return IBlastingItem.findPositions(world, pos, player, radius);
        }
        return Collections.emptyMap();
    }

    private Object2IntMap<BlockPos> getVeinedBlocks(Level world, ItemStack stack, Map<BlockPos, BlockState> blocks, Reference2BooleanMap<Block> oreTracker) {
        IModule veinMiningUnit = this.getModule(stack, MekanismModules.VEIN_MINING_UNIT);
        if (veinMiningUnit != null && veinMiningUnit.isEnabled()) {
            ModuleVeinMiningUnit customInstance = (ModuleVeinMiningUnit)veinMiningUnit.getCustomInstance();
            return ModuleVeinMiningUnit.findPositions(world, blocks, customInstance.isExtended() ? customInstance.getExcavationRange() : 0, oreTracker);
        }
        return (Object2IntMap)blocks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, be -> 0, (l, r) -> l, Object2IntArrayMap::new));
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        if (player.m_9236_().f_46443_ || player.m_7500_()) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null) {
            Reference2BooleanMap oreTracker;
            Map<BlockPos, BlockState> blocks;
            Object2IntMap<BlockPos> veinedBlocks;
            Level world = player.m_9236_();
            BlockState state = world.m_8055_(pos);
            boolean silk = this.isModuleEnabled(stack, MekanismModules.SILK_TOUCH_UNIT);
            FloatingLong modDestroyEnergy = this.getDestroyEnergy(stack, silk);
            FloatingLong energyRequired = this.getDestroyEnergy(modDestroyEnergy, state.m_60800_((BlockGetter)world, pos));
            if (energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL).greaterOrEqual(energyRequired) && !(veinedBlocks = this.getVeinedBlocks(world, stack, blocks = (blocks = this.getBlastedBlocks(world, player, stack, pos, state)).isEmpty() && ModuleVeinMiningUnit.canVeinBlock(state) ? Map.of(pos, state) : blocks, (Reference2BooleanMap<Block>)(oreTracker = (Reference2BooleanMap)blocks.values().stream().collect(Collectors.toMap(BlockBehaviour.BlockStateBase::m_60734_, bs -> bs.m_204336_(MekanismTags.Blocks.ATOMIC_DISASSEMBLER_ORE), (l, r) -> l, Reference2BooleanArrayMap::new))))).isEmpty()) {
                FloatingLong baseDestroyEnergy = this.getDestroyEnergy(silk);
                MekanismUtils.veinMineArea(energyContainer, energyRequired, world, pos, (ServerPlayer)player, stack, this, veinedBlocks, hardness -> this.getDestroyEnergy(modDestroyEnergy, hardness), (hardness, distance, bs) -> this.getDestroyEnergy(baseDestroyEnergy, hardness).multiply(0.5 * Math.pow(distance, oreTracker.getBoolean((Object)bs.m_60734_()) ? 1.5 : 2.0)));
            }
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    private FloatingLong getDestroyEnergy(boolean silk) {
        return silk ? (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageSilk.get() : (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsage.get();
    }

    public FloatingLong getDestroyEnergy(ItemStack itemStack, float hardness, boolean silk) {
        return this.getDestroyEnergy(this.getDestroyEnergy(itemStack, silk), hardness);
    }

    private FloatingLong getDestroyEnergy(FloatingLong baseDestroyEnergy, float hardness) {
        return hardness == 0.0f ? baseDestroyEnergy.divide(2L) : baseDestroyEnergy;
    }

    private FloatingLong getDestroyEnergy(ItemStack itemStack, boolean silk) {
        FloatingLong destroyEnergy = this.getDestroyEnergy(silk);
        IModule module = this.getModule(itemStack, MekanismModules.EXCAVATION_ESCALATION_UNIT);
        float efficiency = module == null || !module.isEnabled() ? MekanismConfig.gear.mekaToolBaseEfficiency.get() : ((ModuleExcavationEscalationUnit)module.getCustomInstance()).getEfficiency();
        return destroyEnergy.multiply(efficiency);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            int unitDamage = 0;
            IModule attackAmplificationUnit = this.getModule(stack, MekanismModules.ATTACK_AMPLIFICATION_UNIT);
            if (attackAmplificationUnit != null && attackAmplificationUnit.isEnabled() && (unitDamage = ((ModuleAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getDamage()) > 0) {
                FloatingLong energy;
                FloatingLong energyCost = ((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageWeapon.get()).multiply((double)unitDamage / 4.0);
                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                FloatingLong floatingLong = energy = energyContainer == null ? FloatingLong.ZERO : energyContainer.getEnergy();
                if (energy.smallerThan(energyCost)) {
                    double bonusDamage = (double)unitDamage * energy.divideToLevel(energyCost);
                    if (bonusDamage > 0.0) {
                        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)MekanismConfig.gear.mekaToolBaseDamage.get() + bonusDamage, AttributeModifier.Operation.ADDITION));
                        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", MekanismConfig.gear.mekaToolAttackSpeed.get(), AttributeModifier.Operation.ADDITION));
                        return builder.build();
                    }
                    unitDamage = 0;
                }
            }
            return (Multimap)((AttributeCache)this.attributeCaches.computeIfAbsent(unitDamage, damage -> new AttributeCache(builder -> {
                builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(MekanismConfig.gear.mekaToolBaseDamage.get() + damage), AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", MekanismConfig.gear.mekaToolAttackSpeed.get(), AttributeModifier.Operation.ADDITION));
            }, MekanismConfig.gear.mekaToolBaseDamage, MekanismConfig.gear.mekaToolAttackSpeed))).get();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        IModule module;
        ItemStack stack = player.m_21120_(hand);
        if (!world.m_5776_() && (module = this.getModule(stack, MekanismModules.TELEPORTATION_UNIT)) != null && module.isEnabled()) {
            BlockPos pos;
            BlockHitResult result = MekanismUtils.rayTrace(player, MekanismConfig.gear.mekaToolMaxTeleportReach.get());
            if ((!((ModuleTeleportationUnit)module.getCustomInstance()).requiresBlockTarget() || result.m_6662_() != HitResult.Type.MISS) && this.isValidDestinationBlock(world, (pos = result.m_82425_()).m_7494_()) && this.isValidDestinationBlock(world, pos.m_6630_(2))) {
                double targetZ;
                double targetY;
                double distance = player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                if (distance < 5.0) {
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                FloatingLong energyNeeded = ((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageTeleport.get()).multiply(distance / 10.0);
                if (energyContainer == null || energyContainer.getEnergy().smallerThan(energyNeeded)) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                double targetX = (double)pos.m_123341_() + 0.5;
                MekanismTeleportEvent.MekaTool event = new MekanismTeleportEvent.MekaTool(player, targetX, targetY = (double)pos.m_123342_() + 1.5, targetZ = (double)pos.m_123343_() + 0.5, stack, result);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                energyContainer.extract(energyNeeded, Action.EXECUTE, AutomationType.MANUAL);
                if (player.m_20159_()) {
                    player.m_142098_(targetX, targetY, targetZ);
                } else {
                    player.m_6021_(targetX, targetY, targetZ);
                }
                player.m_183634_();
                Mekanism.packetHandler().sendToAllTracking(new PacketPortalFX(pos.m_7494_()), world, pos);
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private boolean isValidDestinationBlock(Level world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return blockState.m_60795_() || MekanismUtils.isLiquidBlock(blockState.m_60734_());
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @Override
    public boolean supportsSlotType(ItemStack stack, @NotNull EquipmentSlot slotType) {
        return IGenericRadialModeItem.super.supportsSlotType(stack, slotType) && this.getModules(stack).stream().anyMatch(Module::handlesAnyModeChange);
    }

    @Override
    @Nullable
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return this.getModules(stack).stream().filter(Module::handlesModeChange).findFirst().map(module -> module.getModeScrollComponent(stack)).orElse(null);
    }

    @Override
    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        for (Module module : this.getModules(stack)) {
            if (!module.handlesModeChange()) continue;
            module.changeMode(player, stack, shift, displayChange);
            return;
        }
    }

    @Override
    protected FloatingLong getMaxEnergy(ItemStack stack) {
        IModule module = this.getModule(stack, MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekanismConfig.gear.mekaToolBaseEnergyCapacity.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getEnergyCapacity(module);
    }

    @Override
    protected FloatingLong getChargeRate(ItemStack stack) {
        IModule module = this.getModule(stack, MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekanismConfig.gear.mekaToolBaseChargeRate.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getChargeRate(module);
    }

    @Override
    @Nullable
    public RadialData<?> getRadialData(ItemStack stack) {
        ArrayList<NestedRadialMode> nestedModes = new ArrayList<NestedRadialMode>();
        Consumer<NestedRadialMode> adder = nestedModes::add;
        for (Module module : this.getModules(stack)) {
            if (!module.handlesRadialModeChange()) continue;
            module.addRadialModes(stack, adder);
        }
        if (nestedModes.isEmpty()) {
            return null;
        }
        if (nestedModes.size() == 1) {
            return ((NestedRadialMode)nestedModes.get(0)).nestedData();
        }
        return new NestingRadialData(RADIAL_ID, nestedModes);
    }

    @Override
    @Nullable
    public <M extends IRadialMode> M getMode(ItemStack stack, RadialData<M> radialData) {
        for (Module module : this.getModules(stack)) {
            M mode;
            if (!module.handlesRadialModeChange() || (mode = module.getMode(stack, radialData)) == null) continue;
            return mode;
        }
        return null;
    }

    @Override
    public <M extends IRadialMode> void setMode(ItemStack stack, Player player, RadialData<M> radialData, M mode) {
        for (Module module : this.getModules(stack)) {
            if (!module.handlesRadialModeChange() || !module.setMode(player, stack, radialData, mode)) continue;
            return;
        }
    }
}

