/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.RegistryEntries;

public class ParticleDropColoredData
implements ParticleOptions {
    public static final ParticleDropColoredData INSTANCE = new ParticleDropColoredData(0.0f, 0.0f, 0.0f);
    public static final ParticleOptions.Deserializer<ParticleDropColoredData> DESERIALIZER = new ParticleOptions.Deserializer<ParticleDropColoredData>(){

        public ParticleDropColoredData fromCommand(ParticleType<ParticleDropColoredData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float red = (float)reader.readDouble();
            reader.expect(' ');
            float green = (float)reader.readDouble();
            reader.expect(' ');
            float blue = (float)reader.readDouble();
            return new ParticleDropColoredData(red, green, blue);
        }

        public ParticleDropColoredData fromNetwork(ParticleType<ParticleDropColoredData> particleTypeIn, FriendlyByteBuf buffer) {
            return new ParticleDropColoredData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    public static final Codec<ParticleDropColoredData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("r").forGetter(ParticleDropColoredData::getRed), (App)Codec.FLOAT.fieldOf("g").forGetter(ParticleDropColoredData::getGreen), (App)Codec.FLOAT.fieldOf("b").forGetter(ParticleDropColoredData::getBlue)).apply((Applicative)builder, ParticleDropColoredData::new));
    private final float red;
    private final float green;
    private final float blue;

    public ParticleDropColoredData(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public ParticleType<?> m_6012_() {
        return RegistryEntries.PARTICLE_DROP_COLORED;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }
}

