/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class GuiHelpers {
    public static int SLOT_SIZE = 18;
    public static int SLOT_SIZE_INNER = 16;
    private static final List<Pair<Long, String>> COUNT_SCALES = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)1000000000000000000L, (Object)"E"), Pair.of((Object)1000000000000000L, (Object)"P"), Pair.of((Object)1000000000000L, (Object)"T"), Pair.of((Object)1000000000L, (Object)"G"), Pair.of((Object)1000000L, (Object)"M"), Pair.of((Object)1000L, (Object)"K")});

    public static void renderFluidTank(GuiGraphics gui, @Nullable FluidStack fluidStack, int capacity, int x, int y, int width, int height) {
        if (fluidStack != null && !fluidStack.isEmpty() && capacity > 0) {
            gui.m_280168_().m_85836_();
            GlStateManager._enableBlend();
            GlStateManager._blendFunc((int)770, (int)771);
            Lighting.m_84931_();
            GL11.glEnable((int)2929);
            int level = (int)((double)height * ((double)fluidStack.getAmount() / (double)capacity));
            TextureAtlasSprite icon = RenderHelpers.getFluidIcon(fluidStack, Direction.UP);
            int verticalOffset = 0;
            while (level > 0) {
                int textureHeight;
                if (level > 16) {
                    textureHeight = 16;
                    level -= 16;
                } else {
                    textureHeight = level;
                    level = 0;
                }
                IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((FluidType)fluidStack.getFluid().getFluidType());
                Triple colorParts = Helpers.intToRGB(renderProperties.getTintColor(fluidStack));
                if (fluidStack.getFluid() == Fluids.f_76193_ || fluidStack.getFluid() == Fluids.f_76192_) {
                    colorParts = Triple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.335f), (Object)Float.valueOf(1.0f));
                }
                Lighting.m_84930_();
                RenderSystem.setShaderColor((float)((Float)colorParts.getLeft()).floatValue(), (float)((Float)colorParts.getMiddle()).floatValue(), (float)((Float)colorParts.getRight()).floatValue(), (float)1.0f);
                gui.m_280159_(x, y - textureHeight - verticalOffset + height, 0, width, textureHeight, icon);
                Lighting.m_84931_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                verticalOffset += 16;
            }
            TextureManager textureManager = Minecraft.m_91087_().m_91097_();
            textureManager.m_174784_(TextureAtlas.f_118259_);
            textureManager.m_118506_(TextureAtlas.f_118259_).restoreLastBlurMipmap();
            Lighting.m_84930_();
            gui.m_280168_().m_85849_();
            GL11.glDisable((int)2929);
        }
    }

    public static void renderFluidSlot(GuiGraphics gui, @Nullable FluidStack fluidStack, int x, int y) {
        if (fluidStack != null) {
            GuiHelpers.renderFluidTank(gui, fluidStack, fluidStack.getAmount(), x, y, SLOT_SIZE_INNER, SLOT_SIZE_INNER);
        }
    }

    public static void renderOverlayedFluidTank(GuiGraphics gui, @Nullable FluidStack fluidStack, int capacity, int x, int y, int width, int height, ResourceLocation textureOverlay, int overlayTextureX, int overlayTextureY) {
        GuiHelpers.renderFluidTank(gui, fluidStack, capacity, x, y, width, height);
        if (fluidStack != null && capacity > 0) {
            GlStateManager._enableBlend();
            gui.m_280218_(textureOverlay, x, y, overlayTextureX, overlayTextureY, width, height);
        }
    }

    public static void renderProgressBar(GuiGraphics gui, ResourceLocation texture, int x, int y, int width, int height, int textureX, int textureY, ProgressDirection direction, int progress, int progressMax) {
        if (progressMax > 0 && progress > 0) {
            int offset;
            int scaledWidth = width;
            int scaledHeight = height;
            if (direction.getIncrementX() != 0) {
                scaledWidth = (int)((double)scaledWidth * ((double)progress / (double)progressMax));
            }
            if (direction.getIncrementY() != 0) {
                scaledHeight = (int)((double)scaledHeight * ((double)progress / (double)progressMax));
            }
            if (direction.getIncrementX() < 0) {
                offset = width - scaledWidth;
                x += offset;
                textureX += offset;
            }
            if (direction.getIncrementY() < 0) {
                offset = height - scaledHeight;
                y += offset;
                textureY += offset;
            }
            gui.m_280218_(texture, x, y, textureX, textureY, scaledWidth, scaledHeight);
        }
    }

    public static void drawTooltip(AbstractContainerScreen gui, PoseStack poseStack, List<Component> lines, int x, int y) {
        int guiLeft = gui.getGuiLeft();
        int guiTop = gui.getGuiTop();
        int width = gui.f_96543_;
        int height = gui.f_96544_;
        Minecraft mc = Minecraft.m_91087_();
        GL11.glDisable((int)2929);
        int tooltipWidth = 0;
        for (Component line : lines) {
            int tempWidth = mc.f_91062_.m_92895_(line.getString());
            if (tempWidth <= tooltipWidth) continue;
            tooltipWidth = tempWidth;
        }
        int xStart = x + 12;
        int yStart = y - 12;
        int tooltipHeight = 8;
        if (lines.size() > 1) {
            tooltipHeight += 2 + (lines.size() - 1) * 10;
        }
        if (guiLeft + xStart + tooltipWidth + 6 > width) {
            xStart = width - tooltipWidth - guiLeft - 6;
        }
        if (guiTop + yStart + tooltipHeight + 6 > height) {
            yStart = height - tooltipHeight - guiTop - 6;
        }
        GuiHelpers.drawTooltipBackground(poseStack, xStart, yStart, tooltipWidth, tooltipHeight);
        PoseStack matrixstack = new PoseStack();
        MultiBufferSource.BufferSource irendertypebuffer$impl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        matrixstack.m_85837_(0.0, 0.0, 300.0);
        Matrix4f matrix4f = matrixstack.m_85850_().m_252922_();
        for (int stringIndex = 0; stringIndex < lines.size(); ++stringIndex) {
            Component line = lines.get(stringIndex);
            line = stringIndex == 0 ? Component.m_237113_((String)("\u00a7" + Integer.toHexString(15))).m_7220_(line) : Component.m_237113_((String)"\u00a77").m_7220_(line);
            mc.f_91062_.m_272191_(line.m_7532_(), (float)(xStart + guiLeft), (float)(yStart + guiTop), -1, true, matrix4f, (MultiBufferSource)irendertypebuffer$impl, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            if (stringIndex == 0) {
                yStart += 2;
            }
            yStart += 10;
        }
        irendertypebuffer$impl.m_109911_();
        GL11.glEnable((int)2929);
    }

    public static void drawTooltipBackground(PoseStack poseStack, int xStart, int yStart, int tooltipWidth, int tooltipHeight) {
        float zLevel = 300.0f;
        int color1 = -267386864;
        GuiHelpers.fillGradient(poseStack, xStart - 3, yStart - 4, xStart + tooltipWidth + 3, yStart - 3, color1, color1, zLevel);
        GuiHelpers.fillGradient(poseStack, xStart - 3, yStart + tooltipHeight + 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 4, color1, color1, zLevel);
        GuiHelpers.fillGradient(poseStack, xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color1, color1, zLevel);
        GuiHelpers.fillGradient(poseStack, xStart - 4, yStart - 3, xStart - 3, yStart + tooltipHeight + 3, color1, color1, zLevel);
        GuiHelpers.fillGradient(poseStack, xStart + tooltipWidth + 3, yStart - 3, xStart + tooltipWidth + 4, yStart + tooltipHeight + 3, color1, color1, zLevel);
        int color2 = 0x505000FF;
        int color3 = (color2 & 0xFEFEFE) >> 1 | color2 & 0xFF000000;
        GuiHelpers.fillGradient(poseStack, xStart - 3, yStart - 3 + 1, xStart - 3 + 1, yStart + tooltipHeight + 3 - 1, color2, color3, zLevel);
        GuiHelpers.fillGradient(poseStack, xStart + tooltipWidth + 2, yStart - 3 + 1, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3 - 1, color2, color3, zLevel);
        GuiHelpers.fillGradient(poseStack, xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart - 3 + 1, color2, color2, zLevel);
        GuiHelpers.fillGradient(poseStack, xStart - 3, yStart + tooltipHeight + 2, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color3, color3, zLevel);
    }

    public static void fillGradient(PoseStack poseStack, int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        bufferbuilder.m_252986_(matrix, (float)right, (float)top, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)left, (float)top, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)left, (float)bottom, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)right, (float)bottom, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void renderTooltipOptional(AbstractContainerScreen gui, PoseStack poseStack, int x, int y, int width, int height, int mouseX, int mouseY, Supplier<Optional<List<Component>>> linesSupplier) {
        if (RenderHelpers.isPointInRegion(x, y, width, height, mouseX - gui.getGuiLeft(), mouseY - gui.getGuiTop())) {
            linesSupplier.get().ifPresent(lines -> GuiHelpers.drawTooltip(gui, poseStack, lines, mouseX - gui.getGuiLeft(), mouseY - gui.getGuiTop()));
        }
    }

    public static void renderTooltip(AbstractContainerScreen gui, PoseStack poseStack, int x, int y, int width, int height, int mouseX, int mouseY, Supplier<List<Component>> linesSupplier) {
        GuiHelpers.renderTooltipOptional(gui, poseStack, x, y, width, height, mouseX, mouseY, () -> Optional.of((List)linesSupplier.get()));
    }

    public static String quantityToScaledString(long quantity) {
        for (Pair<Long, String> countScale : COUNT_SCALES) {
            long mod;
            long scale = (Long)countScale.getLeft();
            if (quantity < scale) continue;
            long division = quantity / scale;
            Object divisionString = String.valueOf(division);
            if (division < 10L) {
                long mod2 = quantity % scale;
                if (mod2 > 0L) {
                    long digits = mod2 * 100L / scale;
                    divisionString = (String)divisionString + "." + (digits < 10L ? "0" : "") + String.valueOf(digits);
                }
            } else if (division < 100L && (mod = quantity % scale) > 0L) {
                long digits = mod * 10L / scale;
                divisionString = (String)divisionString + "." + String.valueOf(digits);
            }
            return (String)divisionString + (String)countScale.getRight();
        }
        return String.valueOf(quantity);
    }

    public static enum ProgressDirection {
        UP(0, -1),
        DOWN(0, 1),
        LEFT(-1, 0),
        RIGHT(1, 0),
        UP_LEFT(-1, -1),
        UP_RIGHT(1, -1),
        DOWN_LEFT(-1, 1),
        DOWN_RIGHT(1, 1);

        private final int incrementX;
        private final int incrementY;

        private ProgressDirection(int incrementX, int incrementY) {
            this.incrementX = incrementX;
            this.incrementY = incrementY;
        }

        public int getIncrementX() {
            return this.incrementX;
        }

        public int getIncrementY() {
            return this.incrementY;
        }
    }
}

