/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.stackrefill_common_forge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.ItemFunctions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class RefillEvent {
    private static final List<Pair<Player, ItemStack>> addStackList = Collections.synchronizedList(new ArrayList());
    private static final List<Pair<InteractionHand, Pair<Player, ItemStack>>> addSingleList = Collections.synchronizedList(new ArrayList());
    private static final List<Pair<Player, InteractionHand>> checkFishingRodList = Collections.synchronizedList(new ArrayList());
    private static final List<Pair<InteractionHand, Pair<Player, ItemStack>>> checkItemUsedList = Collections.synchronizedList(new ArrayList());

    public static void onWorldTick(ServerLevel world) {
        RefillEvent.processTick(false);
    }

    public static void processTick(boolean isClientSide) {
        block27: {
            try {
                ItemStack handstack;
                Player player;
                InteractionHand hand;
                Pair insidepair;
                Player player2;
                Pair<Player, ItemStack> pair;
                if (!addStackList.isEmpty()) {
                    pair = addStackList.get(0);
                    if (pair != null) {
                        player2 = (Player)pair.getFirst();
                        ItemStack stackToGive = (ItemStack)pair.getSecond();
                        if (player2.m_6084_()) {
                            ItemStack heldmainhand = player2.m_21205_();
                            if (heldmainhand.m_41619_()) {
                                player2.m_21008_(InteractionHand.MAIN_HAND, stackToGive);
                            } else {
                                ItemFunctions.giveOrDropItemStack((Player)player2, (ItemStack)stackToGive);
                            }
                        } else {
                            player2.m_36176_(stackToGive, false);
                        }
                        player2.m_150109_().m_6596_();
                    }
                    addStackList.remove(0);
                }
                if (!addSingleList.isEmpty()) {
                    pair = addSingleList.get(0);
                    if (pair != null) {
                        insidepair = (Pair)pair.getSecond();
                        hand = (InteractionHand)pair.getFirst();
                        player = (Player)insidepair.getFirst();
                        ItemStack stackToGive = (ItemStack)insidepair.getSecond();
                        if (player.m_6084_()) {
                            handstack = player.m_21120_(hand).m_41777_();
                            player.m_21008_(hand, stackToGive);
                            if (!handstack.m_41619_()) {
                                ItemFunctions.giveOrDropItemStack((Player)player, (ItemStack)handstack);
                            }
                        } else {
                            player.m_36176_(stackToGive, false);
                        }
                        player.m_150109_().m_6596_();
                    }
                    addSingleList.remove(0);
                }
                if (!checkFishingRodList.isEmpty()) {
                    pair = checkFishingRodList.get(0);
                    if (pair != null) {
                        player2 = (Player)pair.getFirst();
                        if (player2.m_6084_() && player2.m_21120_(hand = (InteractionHand)pair.getSecond()).m_41619_()) {
                            Inventory inv = player2.m_150109_();
                            for (int i = 35; i > 8; --i) {
                                ItemStack slot = inv.m_8020_(i);
                                if (!(slot.m_41720_() instanceof FishingRodItem)) continue;
                                player2.m_21008_(hand, slot.m_41777_());
                                slot.m_41764_(0);
                                break;
                            }
                        }
                        player2.m_150109_().m_6596_();
                    }
                    checkFishingRodList.remove(0);
                }
                if (checkItemUsedList.isEmpty()) break block27;
                pair = checkItemUsedList.get(0);
                if (pair != null) {
                    insidepair = (Pair)pair.getSecond();
                    hand = (InteractionHand)pair.getFirst();
                    player = (Player)insidepair.getFirst();
                    if (player.m_6084_() && !player.m_6117_()) {
                        ItemStack usedstack = (ItemStack)insidepair.getSecond();
                        handstack = player.m_21120_(hand).m_41777_();
                        if (!usedstack.m_41720_().equals(handstack.m_41720_()) || usedstack.m_41613_() != handstack.m_41613_()) {
                            boolean shouldcontinue = false;
                            if (handstack.m_41613_() <= 1) {
                                if (usedstack.m_41720_().equals(handstack.m_41720_())) {
                                    if (handstack.m_41619_()) {
                                        shouldcontinue = true;
                                    }
                                } else {
                                    shouldcontinue = true;
                                }
                            }
                            if (shouldcontinue) {
                                Item useditem = usedstack.m_41720_();
                                Inventory inv = player.m_150109_();
                                for (int i = 35; i > 8; --i) {
                                    ItemStack slot = inv.m_8020_(i);
                                    Item slotitem = slot.m_41720_();
                                    if (!useditem.equals(slotitem) || slotitem instanceof PotionItem && !PotionUtils.m_43579_((ItemStack)usedstack).equals(PotionUtils.m_43579_((ItemStack)slot))) continue;
                                    player.m_21008_(hand, slot.m_41777_());
                                    slot.m_41764_(0);
                                    if (!handstack.m_41619_()) {
                                        ItemFunctions.giveOrDropItemStack((Player)player, (ItemStack)handstack);
                                    }
                                    player.m_150109_().m_6596_();
                                    break;
                                }
                            }
                        }
                    }
                }
                checkItemUsedList.remove(0);
            }
            catch (IndexOutOfBoundsException | NoSuchElementException runtimeException) {
                // empty catch block
            }
        }
    }

    public static ItemStack onItemUse(Player player, ItemStack used, ItemStack newItem, InteractionHand hand) {
        if (player.m_7500_()) {
            return null;
        }
        int amount = used.m_41613_();
        if (amount > 1) {
            return null;
        }
        Pair insidepair = new Pair((Object)player, (Object)used.m_41777_());
        Pair pair = new Pair((Object)hand, (Object)insidepair);
        checkItemUsedList.add((Pair<InteractionHand, Pair<Player, ItemStack>>)pair);
        return null;
    }

    public static void onItemBreak(Player player, ItemStack used, InteractionHand hand) {
        if (player.m_7500_()) {
            return;
        }
        if (used == null) {
            return;
        }
        Item useditem = used.m_41720_();
        if (useditem instanceof BlockItem || useditem instanceof BucketItem || useditem instanceof PotionItem) {
            return;
        }
        int amount = used.m_41613_();
        if (amount > 1) {
            return;
        }
        if (hand == null) {
            return;
        }
        Inventory inv = player.m_150109_();
        for (int i = 35; i > 8; --i) {
            ItemStack slot = inv.m_8020_(i);
            Item slotitem = slot.m_41720_();
            if (!useditem.equals(slotitem)) continue;
            Pair insidepair = new Pair((Object)player, (Object)slot.m_41777_());
            Pair pair = new Pair((Object)hand, (Object)insidepair);
            addSingleList.add((Pair<InteractionHand, Pair<Player, ItemStack>>)pair);
            slot.m_41764_(0);
            break;
        }
        player.m_150109_().m_6596_();
    }

    public static void onItemToss(Player player, ItemStack tossedstack) {
        if (player.m_7500_()) {
            return;
        }
        Item tosseditem = tossedstack.m_41720_();
        InteractionHand activehand = InteractionHand.MAIN_HAND;
        ItemStack activestack = player.m_21205_();
        if (!activestack.m_41619_()) {
            return;
        }
        if (tossedstack.m_41613_() > 1) {
            return;
        }
        Inventory inv = player.m_150109_();
        for (int i = 35; i > 8; --i) {
            ItemStack slot = inv.m_8020_(i);
            Item slotitem = slot.m_41720_();
            if (!tosseditem.equals(slotitem) || slotitem instanceof PotionItem && !PotionUtils.m_43579_((ItemStack)tossedstack).equals(PotionUtils.m_43579_((ItemStack)slot))) continue;
            player.m_21008_(activehand, slot.m_41777_());
            slot.m_41764_(0);
            break;
        }
        player.m_150109_().m_6596_();
    }

    public static InteractionResultHolder<ItemStack> onItemRightClick(Player player, Level world, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_7500_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        Item item = stack.m_41720_();
        if (item instanceof FishingRodItem) {
            int damage = stack.m_41773_();
            int maxdamage = stack.m_41776_();
            if (maxdamage - damage < 5) {
                Pair toadd = new Pair((Object)player, (Object)hand);
                checkFishingRodList.add((Pair<Player, InteractionHand>)toadd);
            }
        } else if (item instanceof EggItem || item instanceof SnowballItem || item instanceof FireworkRocketItem) {
            if (stack.m_41613_() > 1) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            Pair insidepair = new Pair((Object)player, (Object)stack.m_41777_());
            Pair pair = new Pair((Object)hand, (Object)insidepair);
            checkItemUsedList.add((Pair<InteractionHand, Pair<Player, ItemStack>>)pair);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static void onBlockRightClick(Level world, Player player, InteractionHand activehand, BlockPos pos, BlockHitResult hitVec) {
        if (player.m_7500_()) {
            return;
        }
        if (player.m_6117_()) {
            return;
        }
        ItemStack active = player.m_21120_(activehand);
        int amount = active.m_41613_();
        if (amount > 26) {
            return;
        }
        Pair insidepair = new Pair((Object)player, (Object)active.m_41777_());
        Pair pair = new Pair((Object)activehand, (Object)insidepair);
        try {
            checkItemUsedList.add((Pair<InteractionHand, Pair<Player, ItemStack>>)pair);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

