/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.corpsecurioscompat;

import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class Config {
    public static final ForgeConfigSpec COMMON;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> BLACKLISTED_ITEMS;
    public static final ForgeConfigSpec.BooleanValue TRANSFER_CURSED_ITEMS;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON);
    }

    public static boolean isItemBlacklisted(Item item) {
        return ((List)BLACKLISTED_ITEMS.get()).contains(BuiltInRegistries.f_257033_.m_7981_((Object)item).toString());
    }

    public static boolean shouldTransferCursedItems() {
        return (Boolean)TRANSFER_CURSED_ITEMS.get();
    }

    public static boolean isItemCursed(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44975_, (ItemStack)stack) > 0;
    }

    static {
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.comment("General settings").push("general");
        BLACKLISTED_ITEMS = COMMON_BUILDER.comment("Items that should not be transferred to curios slots (format: 'modid:item')").defineList("blacklisted_items", List.of(), entry -> entry instanceof String);
        TRANSFER_CURSED_ITEMS = COMMON_BUILDER.comment("Whether cursed items should be transferred back to curios slots (true = transfer cursed items, false = don't transfer)").define("transfer_cursed_items", false);
        COMMON_BUILDER.pop();
        COMMON = COMMON_BUILDER.build();
    }
}

