/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.helper.Helpers;

public class VirtualTank
implements IFluidTank {
    private final ITankProvider tankProvider;
    private final boolean spreadEvenly;

    public VirtualTank(ITankProvider tankProvider, boolean spreadEvenly) {
        this.tankProvider = tankProvider;
        this.spreadEvenly = spreadEvenly;
    }

    protected IFluidHandler[] getTanks() {
        IFluidHandler[] tanks = this.tankProvider.getVirtualTankChildren();
        if (tanks == null) {
            tanks = new IFluidHandler[]{};
        }
        return tanks;
    }

    public FluidStack getFluid() {
        if (this.isSpreadEvenly()) {
            FluidStack minFluid = FluidStack.EMPTY;
            int min = Integer.MAX_VALUE;
            for (IFluidHandler tank : this.getTanks()) {
                int tanks = tank.getTanks();
                for (int i = 0; i < tanks; ++i) {
                    FluidStack tankFluid = tank.getFluidInTank(i);
                    if (tankFluid.isEmpty() || tankFluid.getAmount() >= min) continue;
                    min = tankFluid.getAmount();
                    minFluid = tankFluid;
                }
            }
            return minFluid.isEmpty() ? FluidStack.EMPTY : new FluidStack(minFluid, min * this.getTanks().length);
        }
        FluidStack total = FluidStack.EMPTY;
        for (IFluidHandler tank : this.getTanks()) {
            int tanks = tank.getTanks();
            for (int i = 0; i < tanks; ++i) {
                FluidStack tankFluid = tank.getFluidInTank(i);
                if (tankFluid.isEmpty()) continue;
                if (total.isEmpty()) {
                    total = tankFluid.copy();
                    continue;
                }
                if (total.getFluid() != tankFluid.getFluid()) continue;
                total = new FluidStack(total, total.getAmount() + tankFluid.getAmount());
            }
        }
        return total;
    }

    public int getFluidAmount() {
        return this.getFluid().getAmount();
    }

    public int getCapacity() {
        int total = 0;
        for (IFluidHandler tank : this.getTanks()) {
            int tanks = tank.getTanks();
            for (int i = 0; i < tanks; ++i) {
                total = Helpers.addSafe((int)total, (int)tank.getTankCapacity(i));
            }
        }
        return total;
    }

    public boolean isFluidValid(FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack toFill = resource.copy();
        int totalFilled = 0;
        int tanks = this.getTanks().length;
        IFluidHandler[] tanksArray = this.getTanks();
        for (int i = 0; i < tanks; ++i) {
            IFluidHandler tank = tanksArray[i];
            if (this.isSpreadEvenly()) {
                toFill = resource.copy();
                resource.setAmount(resource.getAmount() / tanks + (i <= resource.getAmount() % tanks ? 1 : 0));
            }
            int filled = tank.fill(toFill, action);
            toFill = toFill.copy();
            toFill.setAmount(toFill.getAmount() - filled);
            if ((totalFilled += filled) != resource.getAmount()) continue;
            return totalFilled;
        }
        return totalFilled;
    }

    protected boolean isSpreadEvenly() {
        return this.spreadEvenly;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int toDrain = maxDrain;
        FluidStack totalDrained = FluidStack.EMPTY;
        int tanks = this.getTanks().length;
        IFluidHandler[] tanksArray = this.getTanks();
        for (int i = 0; i < tanks; ++i) {
            IFluidHandler tank;
            FluidStack drained;
            if (this.isSpreadEvenly()) {
                toDrain = maxDrain / tanks + (i <= maxDrain % tanks ? 1 : 0);
            }
            if ((drained = (tank = tanksArray[i]).drain(toDrain, action)).isEmpty()) continue;
            toDrain -= drained.getAmount();
            if (totalDrained.isEmpty()) {
                totalDrained = drained;
            } else {
                totalDrained.setAmount(totalDrained.getAmount() + drained.getAmount());
            }
            if (totalDrained.getAmount() != maxDrain) continue;
            return totalDrained;
        }
        return totalDrained;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.drain(resource.getAmount(), action);
    }

    public static interface ITankProvider {
        @Nullable
        public IFluidHandler[] getVirtualTankChildren();
    }
}

