/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.inventory;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.inventory.ItemLocation;

public class NBTCraftingGrid
extends TransientCraftingContainer {
    private static final String NBT_TAG_ROOT = "CraftingGridInventory";
    protected Player player;
    protected ItemLocation itemLocation;

    public NBTCraftingGrid(Player player, ItemLocation itemLocation, AbstractContainerMenu eventHandler) {
        super(eventHandler, 3, 3);
        ItemStack itemStack = itemLocation.getItemStack(player);
        this.player = player;
        this.itemLocation = itemLocation;
        InventoryHelpers.validateNBTStorage((Container)this, (ItemStack)itemStack, (String)NBT_TAG_ROOT);
    }

    public void save() {
        ItemStack itemStack = this.itemLocation.getItemStack(this.player);
        CompoundTag tag = itemStack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
        }
        this.writeToNBT(tag, NBT_TAG_ROOT);
        itemStack.m_41751_(tag);
    }

    protected void readFromNBT(CompoundTag data, String tagName) {
        InventoryHelpers.readFromNBT((Container)this, (CompoundTag)data, (String)tagName);
    }

    protected void writeToNBT(CompoundTag data, String tagName) {
        InventoryHelpers.writeToNBT((Container)this, (CompoundTag)data, (String)tagName);
    }
}

