/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.entity.item.EntityThrowable;
import org.cyclops.evilcraft.item.ItemWeatherContainer;

public class EntityWeatherContainer
extends EntityThrowable {
    private static final EntityDataAccessor<ItemStack> ITEMSTACK_INDEX = SynchedEntityData.m_135353_(EntityWeatherContainer.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public EntityWeatherContainer(EntityType<? extends EntityWeatherContainer> type, Level world) {
        super(type, world);
    }

    public EntityWeatherContainer(Level world, LivingEntity entity) {
        super(RegistryEntries.ENTITY_WEATHER_CONTAINER, world, entity);
    }

    public EntityWeatherContainer(Level world, LivingEntity entity, ItemStack stack) {
        this(world, entity);
        this.setItem(stack);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static void playImpactSounds(Level world) {
        if (!world.m_5776_()) {
            for (Object o : world.m_6907_()) {
                Player entityPlayer = (Player)o;
                world.m_6263_(entityPlayer, entityPlayer.m_20185_(), entityPlayer.m_20186_(), entityPlayer.m_20189_(), SoundEvents.f_12287_, SoundSource.WEATHER, 0.5f, 0.4f / (world.f_46441_.m_188501_() * 0.4f + 0.8f));
                world.m_6263_(entityPlayer, entityPlayer.m_20185_(), entityPlayer.m_20186_(), entityPlayer.m_20189_(), SoundEvents.f_11919_, SoundSource.WEATHER, 0.5f, 0.4f / (world.f_46441_.m_188501_() * 0.4f + 0.8f));
                world.m_6263_(entityPlayer, entityPlayer.m_20185_(), entityPlayer.m_20186_(), entityPlayer.m_20189_(), SoundEvents.f_12556_, SoundSource.WEATHER, 0.5f, 0.4f / (world.f_46441_.m_188501_() * 0.4f + 0.8f));
            }
        }
    }

    protected void m_6532_(HitResult movingobjectposition) {
        if (movingobjectposition.m_6662_() == HitResult.Type.BLOCK) {
            ItemStack stack = this.m_7846_();
            ItemWeatherContainer.WeatherContainerType containerType = ItemWeatherContainer.getWeatherType(stack);
            if (this.m_9236_() instanceof ServerLevel) {
                containerType.onUse((ServerLevel)this.m_9236_(), stack);
            }
            EntityWeatherContainer.playImpactSounds(this.m_9236_());
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12436_, SoundSource.AMBIENT, 0.5f, 0.4f, false);
            for (int i = 0; i < 3; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123806_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected float m_7139_() {
        return 0.1f;
    }

    private void setItem(ItemStack stack) {
        this.f_19804_.m_135381_(ITEMSTACK_INDEX, (Object)stack);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ITEMSTACK_INDEX, (Object)new ItemStack((ItemLike)RegistryEntries.ITEM_WEATHER_CONTAINER));
    }

    public ItemStack m_7846_() {
        return (ItemStack)this.f_19804_.m_135370_(ITEMSTACK_INDEX);
    }
}

