/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.event;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.core.algorithm.Wrapper;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;

public class RenderOverlayEventHook {
    private static final int WIDTH = 5;
    private static final int HEIGHT = 51;
    protected static final ResourceLocation BLOOD_OVERLAY = new ResourceLocation("evilcraft", "textures/gui/overlay.png");
    private int filledHeight = -1;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderOverlayEvent(RenderGuiEvent.Post event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (GeneralConfig.bloodGuiOverlay) {
            if (this.filledHeight < 0 || WorldHelpers.efficientTick((Level)player.m_9236_(), (int)50, (int[])new int[0])) {
                Wrapper<Integer> amount = new Wrapper<Integer>(0);
                Wrapper<Integer> capacity = new Wrapper<Integer>(1);
                PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator((Player)player);
                while (it.hasNext()) {
                    ItemStack itemStack = it.next();
                    IFluidHandler fluidHandler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
                    if (itemStack.m_41619_() || fluidHandler == null) continue;
                    FluidStack fluidStack = FluidHelpers.getFluid((IFluidHandler)fluidHandler);
                    if (!fluidStack.isEmpty() && BloodFluidConverter.getInstance().canConvert(fluidStack.getFluid())) {
                        amount.set(amount.get() + fluidStack.getAmount());
                    }
                    if (!fluidStack.isEmpty() && !BloodFluidConverter.getInstance().canConvert(fluidStack.getFluid())) continue;
                    capacity.set(capacity.get() + FluidHelpers.getCapacity((IFluidHandler)fluidHandler));
                }
                this.filledHeight = (int)Math.floor(51.0f * ((float)amount.get().intValue() / (float)capacity.get().intValue()));
            }
            if (this.filledHeight > 0) {
                OverlayPosition overlayPosition = OverlayPosition.values()[Mth.m_14045_((int)GeneralConfig.bloodGuiOverlayPosition, (int)0, (int)(OverlayPosition.values().length - 1))];
                Window resolution = event.getWindow();
                int x = overlayPosition.getX(resolution, 5, 51) + GeneralConfig.bloodGuiOverlayPositionOffsetX;
                int y = overlayPosition.getY(resolution, 5, 51) + GeneralConfig.bloodGuiOverlayPositionOffsetY;
                event.getGuiGraphics().m_280168_().m_85836_();
                GlStateManager._enableBlend();
                GlStateManager._blendFunc((int)770, (int)771);
                RenderHelpers.bindTexture((ResourceLocation)BLOOD_OVERLAY);
                event.getGuiGraphics().m_280218_(BLOOD_OVERLAY, x, y, 0, 0, 5, 51);
                event.getGuiGraphics().m_280218_(BLOOD_OVERLAY, x, y + (51 - this.filledHeight), 5, 51 - this.filledHeight, 5, this.filledHeight);
                GlStateManager._disableBlend();
                event.getGuiGraphics().m_280168_().m_85849_();
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum OverlayPosition {
        NE{

            @Override
            public int getX(Window resolution, int width, int height) {
                return resolution.m_85445_() - width;
            }

            @Override
            public int getY(Window resolution, int width, int height) {
                return 0;
            }
        }
        ,
        SE{

            @Override
            public int getX(Window resolution, int width, int height) {
                return resolution.m_85445_() - width;
            }

            @Override
            public int getY(Window resolution, int width, int height) {
                return resolution.m_85446_() - height;
            }
        }
        ,
        SW{

            @Override
            public int getX(Window resolution, int width, int height) {
                return 0;
            }

            @Override
            public int getY(Window resolution, int width, int height) {
                return resolution.m_85446_() - height;
            }
        }
        ,
        NW{

            @Override
            public int getX(Window resolution, int width, int height) {
                return 0;
            }

            @Override
            public int getY(Window resolution, int width, int height) {
                return 0;
            }
        };


        public abstract int getX(Window var1, int var2, int var3);

        public abstract int getY(Window var1, int var2, int var3);
    }
}

