/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.spiritreanimator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockSpiritReanimatorConfig;

public class SpiritReanimatorRecipeJEI {
    private final FluidStack inputFluid = new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, BlockSpiritReanimatorConfig.mBPerTick * BlockSpiritReanimatorConfig.requiredTicks);
    private final ItemStack inputItem;
    private final ItemStack outputItem;
    private final int duration;

    public SpiritReanimatorRecipeJEI(EntityType<?> entityType) {
        this.inputItem = SpiritReanimatorRecipeJEI.getBox(entityType);
        this.outputItem = new ItemStack((ItemLike)ForgeSpawnEggItem.fromEntityType(entityType));
        this.duration = BlockSpiritReanimatorConfig.requiredTicks;
    }

    public static ItemStack getBox(EntityType<?> entityType) {
        ItemStack stack = new ItemStack((ItemLike)RegistryEntries.BLOCK_BOX_OF_ETERNAL_CLOSURE);
        CompoundTag tag = new CompoundTag();
        CompoundTag spiritTag = new CompoundTag();
        spiritTag.m_128359_("innerEntity", ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString());
        tag.m_128365_("spiritTag", (Tag)spiritTag);
        stack.m_41751_(tag);
        return stack;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public ItemStack getInputItem() {
        return this.inputItem;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public int getDuration() {
        return this.duration;
    }

    public static List<SpiritReanimatorRecipeJEI> getAllRecipes() {
        ArrayList recipes = Lists.newArrayList();
        for (EntityType entityType : ForgeRegistries.ENTITY_TYPES) {
            if (ForgeSpawnEggItem.fromEntityType((EntityType)entityType) == null) continue;
            recipes.add(new SpiritReanimatorRecipeJEI(entityType));
        }
        return recipes;
    }
}

