/*
 * Decompiled with CFR 0.152.
 */
package snownee.autochefsdelight.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.autochefsdelight.AutochefsDelight;
import snownee.autochefsdelight.mixin.RecipeWrapperAccess;
import snownee.autochefsdelight.util.CommonProxy;
import snownee.autochefsdelight.util.DummyRecipeContext;
import snownee.autochefsdelight.util.RecipeMatcher;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;

@Mixin(value={CookingPotBlockEntity.class})
public abstract class CookingPotBlockEntityMixin {
    @Shadow(remap=false)
    @Final
    public static Map<Item, Item> INGREDIENT_REMAINDER_OVERRIDES;
    @Shadow(remap=false)
    private boolean checkNewRecipe;
    @Shadow(remap=false)
    private ResourceLocation lastRecipeID;
    @Unique
    @Nullable
    private RecipeMatcher<ItemStack> lastRecipeMatch;

    @Shadow(remap=false)
    protected abstract void ejectIngredientRemainder(ItemStack var1);

    @Inject(method={"getMatchingRecipe"}, at={@At(value="HEAD")}, remap=false)
    private void getMatchingRecipe(RecipeWrapper inventory, CallbackInfoReturnable<Optional<CookingPotRecipe>> ci, @Local(argsOnly=true) LocalRef<RecipeWrapper> inventoryRef) {
        if (this.checkNewRecipe) {
            this.lastRecipeID = null;
        }
        inventoryRef.set((Object)new DummyRecipeContext(((RecipeWrapperAccess)inventory).getInv(), this::setRecipeMatch));
    }

    @WrapOperation(method={"getMatchingRecipe"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/crafting/RecipeManager;getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/Container;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;", remap=true)}, remap=false)
    private Optional<CookingPotRecipe> getMatchingRecipe(RecipeManager instance, RecipeType<CookingPotRecipe> recipeType, Container ctx, Level level, Operation<Optional<CookingPotRecipe>> original, @Local(argsOnly=true) RecipeWrapper recipeWrapper) {
        for (CookingPotRecipe recipe : AutochefsDelight.COOKING_POT_RECIPES) {
            if (!recipe.matches(recipeWrapper, level)) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    @Inject(method={"processCooking"}, at={@At(value="INVOKE", target="Lvectorwing/farmersdelight/common/block/entity/CookingPotBlockEntity;setRecipeUsed(Lnet/minecraft/world/item/crafting/Recipe;)V", shift=At.Shift.AFTER, remap=true)}, cancellable=true, remap=false)
    private void processCooking(CookingPotRecipe recipe, CookingPotBlockEntity self, CallbackInfoReturnable<Boolean> ci) {
        Level level = Objects.requireNonNull(self.m_58904_());
        if (this.lastRecipeMatch == null) {
            recipe.matches((RecipeWrapper)new DummyRecipeContext((IItemHandlerModifiable)self.getInventory(), this::setRecipeMatch), level);
            if (this.lastRecipeMatch == null) {
                return;
            }
        }
        for (int i = 0; i < this.lastRecipeMatch.inputUsed.length; ++i) {
            int used = this.lastRecipeMatch.inputUsed[i];
            if (used == 0) continue;
            ItemStack stack = (ItemStack)this.lastRecipeMatch.inputs.get(i);
            ItemStack remainder = CommonProxy.getRecipeRemainder(stack);
            if (!remainder.m_41619_()) {
                if (ItemStack.m_150942_((ItemStack)remainder, (ItemStack)stack)) continue;
                this.ejectIngredientRemainder(remainder);
            } else {
                Item remainderItem = INGREDIENT_REMAINDER_OVERRIDES.get(stack.m_41720_());
                if (remainderItem != null) {
                    this.ejectIngredientRemainder(remainderItem.m_7968_());
                }
            }
            stack.m_41774_(used);
        }
        this.lastRecipeMatch = null;
        ci.setReturnValue((Object)true);
    }

    @Unique
    public void setRecipeMatch(@Nullable RecipeMatcher<ItemStack> match) {
        this.lastRecipeMatch = match;
    }
}

