/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.elements;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class GuiRectangle
extends GuiElement<GuiRectangle>
implements BackgroundRender {
    private Supplier<Integer> fill = null;
    private Supplier<Integer> border = null;
    private Supplier<Double> borderWidth = () -> 1.0;
    private Supplier<Integer> shadeTopLeft;
    private Supplier<Integer> shadeBottomRight;
    private Supplier<Integer> shadeCorners;

    public GuiRectangle(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public static GuiRectangle vanillaSlot(@NotNull GuiParent<?> parent) {
        return new GuiRectangle(parent).shadedRect(-13158601, -1, -7631989, -7631989);
    }

    public static GuiRectangle invertedSlot(@NotNull GuiParent<?> parent) {
        return new GuiRectangle(parent).shadedRect(-1, -13158601, -7631989, -7631989);
    }

    public static GuiRectangle planeButton(@NotNull GuiParent<?> parent) {
        return new GuiRectangle(parent).shadedRect(-5592406, -11250604, -9474193);
    }

    public static GuiRectangle toolTipBackground(@NotNull GuiParent<?> parent) {
        return GuiRectangle.toolTipBackground(parent, -267386864, 0x505000FF, 1344798847);
    }

    public static GuiRectangle toolTipBackground(@NotNull GuiParent<?> parent, int backgroundColour, int borderColourTop, int borderColourBottom) {
        return GuiRectangle.toolTipBackground(parent, backgroundColour, backgroundColour, borderColourTop, borderColourBottom);
    }

    public static GuiRectangle toolTipBackground(@NotNull GuiParent<?> parent, final int backgroundColourTop, final int backgroundColourBottom, final int borderColourTop, final int borderColourBottom) {
        return new GuiRectangle(parent){

            @Override
            public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
                render.toolTipBackground(this.xMin(), this.yMin(), this.xSize(), this.ySize(), backgroundColourTop, backgroundColourBottom, borderColourTop, borderColourBottom, false);
            }
        };
    }

    public GuiRectangle border(int border) {
        return this.border(() -> border);
    }

    public GuiRectangle border(Supplier<Integer> border) {
        this.border = border;
        return this;
    }

    public GuiRectangle fill(int fill) {
        return this.fill(() -> fill);
    }

    public GuiRectangle fill(Supplier<Integer> fill) {
        this.fill = fill;
        return this;
    }

    public GuiRectangle rectangle(int fill, int border) {
        return this.rectangle(() -> fill, () -> border);
    }

    public GuiRectangle rectangle(Supplier<Integer> fill, Supplier<Integer> border) {
        this.fill = fill;
        this.border = border;
        return this;
    }

    public GuiRectangle shadedRect(int topLeft, int bottomRight, int fill) {
        return this.shadedRect(() -> topLeft, () -> bottomRight, () -> fill);
    }

    public GuiRectangle shadedRect(Supplier<Integer> topLeft, Supplier<Integer> bottomRight, Supplier<Integer> fill) {
        return this.shadedRect(topLeft, bottomRight, () -> GuiRender.midColour((Integer)topLeft.get(), (Integer)bottomRight.get()), fill);
    }

    public GuiRectangle shadedRect(int topLeft, int bottomRight, int cornerMix, int fill) {
        return this.shadedRect(() -> topLeft, () -> bottomRight, () -> cornerMix, () -> fill);
    }

    public GuiRectangle shadedRect(Supplier<Integer> topLeft, Supplier<Integer> bottomRight, Supplier<Integer> cornerMix, Supplier<Integer> fill) {
        this.fill = fill;
        this.shadeTopLeft = topLeft;
        this.shadeBottomRight = bottomRight;
        this.shadeCorners = cornerMix;
        return this;
    }

    public GuiRectangle setShadeTopLeft(Supplier<Integer> shadeTopLeft) {
        this.shadeTopLeft = shadeTopLeft;
        return this;
    }

    public GuiRectangle setShadeBottomRight(Supplier<Integer> shadeBottomRight) {
        this.shadeBottomRight = shadeBottomRight;
        return this;
    }

    public GuiRectangle setShadeCorners(Supplier<Integer> shadeCorners) {
        this.shadeCorners = shadeCorners;
        return this;
    }

    public GuiRectangle setShadeCornersAuto() {
        this.shadeCorners = () -> GuiRender.midColour(this.shadeTopLeft.get(), this.shadeBottomRight.get());
        return this;
    }

    public GuiRectangle borderWidth(double borderWidth) {
        return this.borderWidth(() -> borderWidth);
    }

    public GuiRectangle borderWidth(Supplier<Double> borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public double getBorderWidth() {
        return this.borderWidth.get();
    }

    @Override
    public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        if (this.shadeTopLeft != null && this.shadeBottomRight != null && this.shadeCorners != null) {
            render.shadedRect(this.getRectangle(), this.getBorderWidth(), this.shadeTopLeft.get(), this.shadeBottomRight.get(), this.shadeCorners.get(), this.fill == null ? 0 : this.fill.get());
        } else if (this.border != null) {
            render.borderRect(this.getRectangle(), this.getBorderWidth(), this.fill == null ? 0 : this.fill.get(), this.border.get());
        } else if (this.fill != null) {
            render.rect(this.getRectangle(), this.fill.get());
        }
    }
}

