/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.lib.container;

import codechicken.lib.inventory.container.modular.ModularGuiContainerMenu;
import codechicken.lib.inventory.container.modular.ModularSlot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class SlotGroup {
    public final int zone;
    public final List<Integer> quickMoveTo;
    private final ModularGuiContainerMenu containerMenu;
    private final List<ModularSlot> slots = new ArrayList<ModularSlot>();

    public SlotGroup(ModularGuiContainerMenu containerMenu, int zone, int ... quickMoveTo) {
        this.zone = zone;
        this.containerMenu = containerMenu;
        this.quickMoveTo = Arrays.stream(quickMoveTo).boxed().toList();
    }

    public ModularSlot addSlot(ModularSlot slot) {
        this.slots.add(slot);
        this.containerMenu.m_38897_((Slot)slot);
        this.containerMenu.mapSlot((Slot)slot, this);
        return slot;
    }

    public void addSlots(int slotCount, int startIndex, Function<Integer, ModularSlot> makeSlot) {
        for (int index = startIndex; index < startIndex + slotCount; ++index) {
            this.addSlot(makeSlot.apply(index));
        }
    }

    public void addAllSlots(Container container) {
        this.addAllSlots(container, ModularSlot::new);
    }

    public void addAllSlots(Container container, BiFunction<Container, Integer, ModularSlot> makeSlot) {
        for (int index = 0; index < container.m_6643_(); ++index) {
            this.addSlot(makeSlot.apply(container, index));
        }
    }

    public void addPlayerMain(Inventory inventory) {
        this.addSlots(27, 9, index -> new ModularSlot((Container)inventory, (int)index));
    }

    public void addPlayerBar(Inventory inventory) {
        this.addSlots(9, 0, index -> new ModularSlot((Container)inventory, (int)index));
    }

    public void addPlayerArmor(Inventory inventory) {
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot slot = EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)(3 - i));
            this.addSlot(new ModularSlot((Container)inventory, 39 - i).onSet((oldStack, newStack) -> SlotGroup.onEquipItem(inventory, slot, newStack, oldStack)).setStackLimit(stack -> 1).setValidator(stack -> slot == Mob.m_147233_((ItemStack)stack)).setCanRemove((player, stack) -> stack.m_41619_() || player.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)stack)));
        }
    }

    public void addPlayerOffhand(Inventory inventory) {
        this.addSlot(new ModularSlot((Container)inventory, 40).onSet((oldStack, newStack) -> SlotGroup.onEquipItem(inventory, EquipmentSlot.OFFHAND, newStack, oldStack)));
    }

    static void onEquipItem(Inventory inventory, EquipmentSlot slot, ItemStack newStack, ItemStack oldStack) {
        inventory.f_35978_.m_238392_(slot, oldStack, newStack);
    }

    public int size() {
        return this.slots.size();
    }

    public ModularSlot getSlot(int index) {
        return this.slots.get(index);
    }

    public int indexOf(Slot slot) {
        return this.slots.indexOf(slot);
    }

    public List<ModularSlot> slots() {
        return Collections.unmodifiableList(this.slots);
    }
}

